/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.EmbeddedResource;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Resource;
import aQute.libg.qtokens.QuotedTokenizer;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Verifier
extends Analyzer {
    Jar dot;
    Manifest manifest;
    Map<String, Map<String, String>> referred = Verifier.newHashMap();
    Map<String, Map<String, String>> contained = Verifier.newHashMap();
    Map<String, Set<String>> uses = Verifier.newHashMap();
    Map<String, Map<String, String>> mimports;
    Map<String, Map<String, String>> mdynimports;
    Map<String, Map<String, String>> mexports;
    List<Jar> bundleClasspath;
    Map<String, Map<String, String>> ignore = Verifier.newHashMap();
    Map<String, Clazz> classSpace;
    boolean r3;
    boolean usesRequire;
    boolean fragment;
    Attributes main;
    static final Pattern EENAME = Pattern.compile("CDC-1\\.0/Foundation-1\\.0|CDC-1\\.1/Foundation-1\\.1|OSGi/Minimum-1\\.[1-9]|JRE-1\\.1|J2SE-1\\.2|J2SE-1\\.3|J2SE-1\\.4|J2SE-1\\.5|JavaSE-1\\.6|PersonalJava-1\\.1|PersonalJava-1\\.2|CDC-1\\.0/PersonalBasis-1\\.0|CDC-1\\.0/PersonalJava-1\\.0");
    static final Pattern BUNDLEMANIFESTVERSION = Pattern.compile("2");
    public static final String SYMBOLICNAME_STRING = "[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)*";
    public static final Pattern SYMBOLICNAME = Pattern.compile("[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)*");
    public static final String VERSION_STRING = "[0-9]+(\\.[0-9]+(\\.[0-9]+(\\.[0-9A-Za-z_-]+)?)?)?";
    public static final Pattern VERSION = Pattern.compile("[0-9]+(\\.[0-9]+(\\.[0-9]+(\\.[0-9A-Za-z_-]+)?)?)?");
    static final Pattern FILTEROP = Pattern.compile("=|<=|>=|~=");
    static final Pattern VERSIONRANGE = Pattern.compile("((\\(|\\[)[0-9]+(\\.[0-9]+(\\.[0-9]+(\\.[0-9A-Za-z_-]+)?)?)?,[0-9]+(\\.[0-9]+(\\.[0-9]+(\\.[0-9A-Za-z_-]+)?)?)?(\\]|\\)))|[0-9]+(\\.[0-9]+(\\.[0-9]+(\\.[0-9A-Za-z_-]+)?)?)?");
    static final Pattern FILE = Pattern.compile("/?[^/\"\n\r\u0000]+(/[^/\"\n\r\u0000]+)*");
    static final Pattern WILDCARDPACKAGE = Pattern.compile("((\\p{Alnum}|_)+(\\.(\\p{Alnum}|_)+)*(\\.\\*)?)|\\*");
    static final Pattern ISO639 = Pattern.compile("[A-Z][A-Z]");
    public static Pattern HEADER_PATTERN = Pattern.compile("[A-Za-z0-9][-a-zA-Z0-9_]+");
    public static Pattern TOKEN = Pattern.compile("[-a-zA-Z0-9_]+");
    Properties properties;

    public Verifier(Jar jar) throws Exception {
        this(jar, null);
    }

    public Verifier(Jar jar, Properties properties) throws Exception {
        this.dot = jar;
        this.properties = properties;
        this.manifest = jar.getManifest();
        if (this.manifest == null) {
            this.manifest = new Manifest();
            this.error("This file contains no manifest and is therefore not a bundle", new Object[0]);
        }
        this.main = this.manifest.getMainAttributes();
        this.verifyHeaders(this.main);
        this.r3 = this.getHeader("Bundle-ManifestVersion") == null;
        this.usesRequire = this.getHeader("Require-Bundle") != null;
        this.fragment = this.getHeader("Fragment-Host") != null;
        this.bundleClasspath = this.getBundleClassPath();
        this.mimports = this.parseHeader(this.manifest.getMainAttributes().getValue("Import-Package"));
        this.mdynimports = this.parseHeader(this.manifest.getMainAttributes().getValue("DynamicImport-Package"));
        this.mexports = this.parseHeader(this.manifest.getMainAttributes().getValue("Export-Package"));
        this.ignore = this.parseHeader(this.manifest.getMainAttributes().getValue("Ignore-Package"));
    }

    public Verifier() {
    }

    private void verifyHeaders(Attributes main) {
        for (Object element : main.keySet()) {
            Attributes.Name header = (Attributes.Name)element;
            String h = header.toString();
            if (HEADER_PATTERN.matcher(h).matches()) continue;
            this.error("Invalid Manifest header: " + h + ", pattern=" + HEADER_PATTERN, new Object[0]);
        }
    }

    private List<Jar> getBundleClassPath() {
        List<Jar> list = this.newList();
        String bcp = this.getHeader("Bundle-ClassPath");
        if (bcp == null) {
            list.add(this.dot);
        } else {
            Map<String, Map<String, String>> entries = this.parseHeader(bcp);
            for (String jarOrDir : entries.keySet()) {
                Jar sub;
                Resource resource;
                if (jarOrDir.equals(".")) {
                    list.add(this.dot);
                    continue;
                }
                if (jarOrDir.equals("/")) {
                    jarOrDir = "";
                }
                if (jarOrDir.endsWith("/")) {
                    this.error("Bundle-Classpath directory must not end with a slash: " + jarOrDir, new Object[0]);
                    jarOrDir = jarOrDir.substring(0, jarOrDir.length() - 1);
                }
                if ((resource = this.dot.getResource(jarOrDir)) != null) {
                    try {
                        sub = new Jar(jarOrDir);
                        this.addClose(sub);
                        EmbeddedResource.build(sub, resource);
                        if (!jarOrDir.endsWith(".jar")) {
                            this.warning("Valid JAR file on Bundle-Classpath does not have .jar extension: " + jarOrDir, new Object[0]);
                        }
                        list.add(sub);
                    }
                    catch (Exception e) {
                        this.error("Invalid embedded JAR file on Bundle-Classpath: " + jarOrDir + ", " + e, new Object[0]);
                    }
                    continue;
                }
                if (this.dot.getDirectories().containsKey(jarOrDir)) {
                    if (this.r3) {
                        this.error("R3 bundles do not support directories on the Bundle-ClassPath: " + jarOrDir, new Object[0]);
                    }
                    try {
                        sub = new Jar(jarOrDir);
                        this.addClose(sub);
                        for (Map.Entry<String, Resource> entry : this.dot.getResources().entrySet()) {
                            if (!entry.getKey().startsWith(jarOrDir)) continue;
                            sub.putResource(entry.getKey().substring(jarOrDir.length() + 1), entry.getValue());
                        }
                        list.add(sub);
                    }
                    catch (Exception e) {
                        this.error("Invalid embedded directory file on Bundle-Classpath: " + jarOrDir + ", " + e, new Object[0]);
                    }
                    continue;
                }
                this.error("Cannot find a file or directory for Bundle-Classpath entry: " + jarOrDir, new Object[0]);
            }
        }
        return list;
    }

    public void verifyNative() {
        String nc = this.getHeader("Bundle-NativeCode");
        this.doNative(nc);
    }

    public void doNative(String nc) {
        if (nc != null) {
            char del;
            QuotedTokenizer qt = new QuotedTokenizer(nc, ",;=", false);
            do {
                String key;
                String name;
                if ((name = qt.nextToken()) == null) {
                    this.error("Can not parse name from bundle native code header: " + nc, new Object[0]);
                    return;
                }
                del = qt.getSeparator();
                if (del == ';') {
                    if (this.dot == null || this.dot.exists(name)) continue;
                    this.error("Native library not found in JAR: " + name, new Object[0]);
                    continue;
                }
                String value = null;
                if (del == '=') {
                    value = qt.nextToken();
                }
                if (!(key = name.toLowerCase()).equals("osname")) {
                    if (key.equals("osversion")) {
                        this.verify(value, VERSIONRANGE);
                    } else if (key.equals("language")) {
                        this.verify(value, ISO639);
                    } else if (!key.equals("processor")) {
                        if (key.equals("selection-filter")) {
                            this.verifyFilter(value);
                        } else if (name.equals("*") && value == null) {
                            if (qt.nextToken() != null) {
                                this.error("Bundle-Native code header may only END in wildcard: nc", new Object[0]);
                            }
                        } else {
                            this.warning("Unknown attribute in native code: " + name + "=" + value, new Object[0]);
                        }
                    }
                }
                del = qt.getSeparator();
            } while (del == ';' || del == ',');
        }
    }

    public void verifyFilter(String value) {
        try {
            this.verifyFilter(value, 0);
        }
        catch (Exception e) {
            this.error("Not a valid filter: " + value + e.getMessage(), new Object[0]);
        }
    }

    private void verifyActivator() {
        Clazz cl;
        String bactivator = this.getHeader("Bundle-Activator");
        if (bactivator != null && (cl = this.loadClass(bactivator)) == null) {
            int n = bactivator.lastIndexOf(46);
            if (n > 0) {
                String pack = bactivator.substring(0, n);
                if (this.mimports.containsKey(pack)) {
                    return;
                }
                this.error("Bundle-Activator not found on the bundle class path nor in imports: " + bactivator, new Object[0]);
            } else {
                this.error("Activator uses default package and is not local (default package can not be imported): " + bactivator, new Object[0]);
            }
        }
    }

    private Clazz loadClass(String className) {
        String path = String.valueOf(className.replace('.', '/')) + ".class";
        return this.classSpace.get(path);
    }

    private void verifyComponent() {
        String serviceComponent = this.getHeader("Service-Component");
        if (serviceComponent != null) {
            Map<String, Map<String, String>> map = this.parseHeader(serviceComponent);
            for (String component : map.keySet()) {
                if (this.dot.exists(component)) continue;
                this.error("Service-Component entry can not be located in JAR: " + component, new Object[0]);
            }
        }
    }

    public void info() {
        System.out.println("Refers                           : " + this.referred);
        System.out.println("Contains                         : " + this.contained);
        System.out.println("Manifest Imports                 : " + this.mimports);
        System.out.println("Manifest Exports                 : " + this.mexports);
    }

    private void verifyInvalidExports() {
        Set invalidExport = this.newSet((Collection)this.mexports.keySet());
        invalidExport.removeAll((Collection)this.contained.keySet());
        Iterator i = invalidExport.iterator();
        while (i.hasNext()) {
            String pack = (String)i.next();
            if (!Verifier.isDuplicate(pack)) continue;
            i.remove();
        }
        if (!invalidExport.isEmpty()) {
            this.error("Exporting packages that are not on the Bundle-Classpath" + this.bundleClasspath + ": " + invalidExport, new Object[0]);
        }
    }

    private void verifyInvalidImports() {
        int n;
        Set invalidImport = this.newSet((Collection)this.mimports.keySet());
        invalidImport.removeAll((Collection)this.referred.keySet());
        invalidImport.removeAll((Collection)this.contained.keySet());
        String bactivator = this.getHeader("Bundle-Activator");
        if (bactivator != null && (n = bactivator.lastIndexOf(46)) > 0) {
            invalidImport.remove(bactivator.substring(0, n));
        }
        if (this.isPedantic() && !invalidImport.isEmpty()) {
            this.warning("Importing packages that are never refered to by any class on the Bundle-Classpath" + this.bundleClasspath + ": " + invalidImport, new Object[0]);
        }
    }

    private void verifyUnresolvedReferences() {
        TreeSet unresolvedReferences = new TreeSet(this.referred.keySet());
        unresolvedReferences.removeAll((Collection)this.mimports.keySet());
        unresolvedReferences.removeAll((Collection)this.contained.keySet());
        Iterator p = unresolvedReferences.iterator();
        while (p.hasNext()) {
            String pack = (String)p.next();
            if (pack.startsWith("java.") || this.ignore.containsKey(pack)) {
                p.remove();
                continue;
            }
            if (!this.isDynamicImport(pack)) continue;
            p.remove();
        }
        if (!unresolvedReferences.isEmpty()) {
            HashSet<String> culprits = new HashSet<String>();
            for (Clazz clazz : this.classSpace.values()) {
                if (!this.hasOverlap(unresolvedReferences, clazz.imports.keySet())) continue;
                culprits.add(clazz.getPath());
            }
            this.error("Unresolved references to " + unresolvedReferences + " by class(es) on the Bundle-Classpath" + this.bundleClasspath + ": " + culprits, new Object[0]);
        }
    }

    private boolean isDynamicImport(String pack) {
        for (String pattern : this.mdynimports.keySet()) {
            if (pattern.equals("*")) {
                return true;
            }
            if (!(pattern.endsWith(".*") ? pack.startsWith(pattern = pattern.substring(0, pattern.length() - 2)) && (pack.length() == pattern.length() || pack.charAt(pattern.length()) == '.') : pack.equals(pattern))) continue;
            return true;
        }
        return false;
    }

    private boolean hasOverlap(Set<?> a, Set<?> b) {
        Iterator<?> i = a.iterator();
        while (i.hasNext()) {
            if (!b.contains(i.next())) continue;
            return true;
        }
        return false;
    }

    public void verify() throws IOException {
        if (this.classSpace == null) {
            this.classSpace = this.analyzeBundleClasspath(this.dot, this.parseHeader(this.getHeader("Bundle-ClassPath")), this.contained, this.referred, this.uses);
        }
        this.verifyManifestFirst();
        this.verifyActivator();
        this.verifyComponent();
        this.verifyNative();
        this.verifyInvalidExports();
        this.verifyInvalidImports();
        this.verifyUnresolvedReferences();
        this.verifySymbolicName();
        this.verifyListHeader("Bundle-RequiredExecutionEnvironment", EENAME, false);
        this.verifyHeader("Bundle-ManifestVersion", BUNDLEMANIFESTVERSION, false);
        this.verifyHeader("Bundle-Version", VERSION, true);
        this.verifyListHeader("Bundle-Classpath", FILE, false);
        this.verifyDynamicImportPackage();
        this.verifyBundleClasspath();
        if (this.usesRequire && !this.getErrors().isEmpty()) {
            this.getWarnings().add(0, "Bundle uses Require Bundle, this can generate false errors because then not enough information is available without the required bundles");
        }
    }

    public void verifyBundleClasspath() {
        Map<String, Map<String, String>> bcp = this.parseHeader(this.getHeader("Bundle-ClassPath"));
        if (bcp.isEmpty() || bcp.containsKey(".")) {
            return;
        }
        for (String path : this.dot.getResources().keySet()) {
            if (!path.endsWith(".class")) continue;
            this.warning("The Bundle-Classpath does not contain the actual bundle JAR (as specified with '.' in the Bundle-Classpath) but the JAR does contain classes. Is this intentional?", new Object[0]);
            return;
        }
    }

    private void verifyDynamicImportPackage() {
        this.verifyListHeader("DynamicImport-Package", WILDCARDPACKAGE, true);
        String dynamicImportPackage = this.getHeader("DynamicImport-Package");
        if (dynamicImportPackage == null) {
            return;
        }
        Map<String, Map<String, String>> map = this.parseHeader(dynamicImportPackage);
        for (String name : map.keySet()) {
            if (!this.verify(name = name.trim(), WILDCARDPACKAGE)) {
                this.error("DynamicImport-Package header contains an invalid package name: " + name, new Object[0]);
            }
            Map<String, String> sub = map.get(name);
            if (!this.r3 || sub.size() == 0) continue;
            this.error("DynamicPackage-Import has attributes on import: " + name + ". This is however, an <=R3 bundle and attributes on this header were introduced in R4. ", new Object[0]);
        }
    }

    private void verifyManifestFirst() {
        if (!this.dot.manifestFirst) {
            this.error("Invalid JAR stream: Manifest should come first to be compatible with JarInputStream, it was not", new Object[0]);
        }
    }

    private void verifySymbolicName() {
        Map<String, Map<String, String>> bsn = this.parseHeader(this.getHeader("Bundle-SymbolicName"));
        if (!bsn.isEmpty()) {
            String name;
            if (bsn.size() > 1) {
                this.error("More than one BSN specified " + bsn, new Object[0]);
            }
            if (!SYMBOLICNAME.matcher(name = bsn.keySet().iterator().next()).matches()) {
                this.error("Symbolic Name has invalid format: " + name, new Object[0]);
            }
        }
    }

    int verifyFilter(String expr, int index) {
        try {
            while (Character.isWhitespace(expr.charAt(index))) {
                ++index;
            }
            if (expr.charAt(index) != '(') {
                throw new IllegalArgumentException("Filter mismatch: expected ( at position " + index + " : " + expr);
            }
            ++index;
            while (Character.isWhitespace(expr.charAt(index))) {
                ++index;
            }
            switch (expr.charAt(index)) {
                case '!': 
                case '&': 
                case '|': {
                    return this.verifyFilterSubExpression(expr, index) + 1;
                }
            }
            return this.verifyFilterOperation(expr, index) + 1;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Filter mismatch: early EOF from " + index);
        }
    }

    private int verifyFilterOperation(String expr, int index) {
        StringBuffer sb = new StringBuffer();
        while ("=><~()".indexOf(expr.charAt(index)) < 0) {
            sb.append(expr.charAt(index++));
        }
        String attr = sb.toString().trim();
        if (attr.length() == 0) {
            throw new IllegalArgumentException("Filter mismatch: attr at index " + index + " is 0");
        }
        sb = new StringBuffer();
        while ("=><~".indexOf(expr.charAt(index)) >= 0) {
            sb.append(expr.charAt(index++));
        }
        String operator = sb.toString();
        if (!this.verify(operator, FILTEROP)) {
            throw new IllegalArgumentException("Filter error, illegal operator " + operator + " at index " + index);
        }
        sb = new StringBuffer();
        while (")".indexOf(expr.charAt(index)) < 0) {
            switch (expr.charAt(index)) {
                case '\\': {
                    if (expr.charAt(index + 1) == '*' || expr.charAt(index + 1) == ')') break;
                    throw new IllegalArgumentException("Filter error, illegal use of backslash at index " + index + ". Backslash may only be used before * or (");
                }
            }
            int n = ++index;
            ++index;
            sb.append(expr.charAt(n));
        }
        return index;
    }

    private int verifyFilterSubExpression(String expr, int index) {
        do {
            index = this.verifyFilter(expr, index + 1);
            while (Character.isWhitespace(expr.charAt(index))) {
                ++index;
            }
            if (expr.charAt(index) == ')') continue;
            throw new IllegalArgumentException("Filter mismatch: expected ) at position " + index + " : " + expr);
        } while (expr.charAt(++index) == '(');
        return index;
    }

    private String getHeader(String string) {
        return this.main.getValue(string);
    }

    private boolean verifyHeader(String name, Pattern regex, boolean error) {
        String value = this.manifest.getMainAttributes().getValue(name);
        if (value == null) {
            return false;
        }
        QuotedTokenizer st = new QuotedTokenizer(value.trim(), ",");
        Iterator<String> i = st.getTokenSet().iterator();
        while (i.hasNext()) {
            if (this.verify(i.next(), regex)) continue;
            String msg = "Invalid value for " + name + ", " + value + " does not match " + regex.pattern();
            if (error) {
                this.error(msg, new Object[0]);
                continue;
            }
            this.warning(msg, new Object[0]);
        }
        return true;
    }

    private boolean verify(String value, Pattern regex) {
        return regex.matcher(value).matches();
    }

    private boolean verifyListHeader(String name, Pattern regex, boolean error) {
        String value = this.manifest.getMainAttributes().getValue(name);
        if (value == null) {
            return false;
        }
        Map<String, Map<String, String>> map = this.parseHeader(value);
        for (String header : map.keySet()) {
            if (regex.matcher(header).matches()) continue;
            String msg = "Invalid value for " + name + ", " + value + " does not match " + regex.pattern();
            if (error) {
                this.error(msg, new Object[0]);
                continue;
            }
            this.warning(msg, new Object[0]);
        }
        return true;
    }

    @Override
    public String getProperty(String key, String deflt) {
        if (this.properties == null) {
            return deflt;
        }
        return this.properties.getProperty(key, deflt);
    }

    public void setClassSpace(Map<String, Clazz> classspace, Map<String, Map<String, String>> contained, Map<String, Map<String, String>> referred, Map<String, Set<String>> uses) {
        this.classSpace = classspace;
        this.contained = contained;
        this.referred = referred;
        this.uses = uses;
    }

    public static boolean isVersion(String version) {
        return VERSION.matcher(version).matches();
    }
}

