/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.sslfilter.internal;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.felix.http.sslfilter.internal.SslFilterRequest;
import org.apache.felix.http.sslfilter.internal.SslFilterResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.servlet.whiteboard.Preprocessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(ocd=Config.class)
@Component(service={Preprocessor.class}, configurationPid={"org.apache.felix.http.sslfilter.Configuration"}, property={"osgi.http.whiteboard.context.select=(osgi.http.whiteboard.context.name=*)", "osgi.http.whiteboard.filter.pattern=/"})
public class SslFilter
implements Preprocessor {
    public static final Logger LOGGER = LoggerFactory.getLogger(SslFilter.class);
    private volatile Config config;

    @Activate
    public SslFilter(Config config) {
        this.updateConfig(config);
    }

    @Modified
    public void updateConfig(Config config) {
        this.config = config;
        LOGGER.info("SSL filter (re)configured with: rewrite absolute urls = {}; SSL forward header = '{}'; SSL forward value = '{}'; SSL certificate header = '{}'", new Object[]{config.rewrite_absolute_urls(), config.ssl_forward_header(), config.ssl_forward_value(), config.ssl_forward_cert_header()});
    }

    public void init(FilterConfig config) {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        Config cfg = this.config;
        Object httpReq = (HttpServletRequest)req;
        Object httpResp = (HttpServletResponse)res;
        if (cfg.ssl_forward_value().equalsIgnoreCase(httpReq.getHeader(cfg.ssl_forward_header()))) {
            httpResp = new SslFilterResponse((HttpServletResponse)httpResp, (HttpServletRequest)httpReq, cfg);
            httpReq = new SslFilterRequest((HttpServletRequest)httpReq, httpReq.getHeader(cfg.ssl_forward_cert_header()));
        }
        try {
            chain.doFilter((ServletRequest)httpReq, (ServletResponse)httpResp);
        }
        finally {
            if (httpReq instanceof SslFilterRequest) {
                ((SslFilterRequest)((Object)httpReq)).done();
            }
        }
    }

    @ObjectClassDefinition(name="Apache Felix Http Service SSL Filter", description="Configuration for the Http Service SSL Filter. Please consult the documentation of your proxy for the actual headers and values to use.")
    public static @interface Config {
        @AttributeDefinition(name="SSL forward header", description="HTTP Request header name that indicates a request is a SSL request terminated at a proxy between the client and the originating server. The default value is 'X-Forwarded-SSL' as is customarily used in the wild. Other commonly used names are: 'X-Forwarded-Proto' (Amazon ELB), 'X-Forwarded-Protocol' (alternative), and 'Front-End-Https' (Microsoft IIS).")
        public String ssl_forward_header() default "X-Forwarded-SSL";

        @AttributeDefinition(name="SSL forward value", description="HTTP Request header value that indicates a request is a SSL request terminated at a proxy. The default value is 'on'. Another commonly used value is 'https'.")
        public String ssl_forward_value() default "on";

        @AttributeDefinition(name="SSL client header", description="HTTP Request header name that contains the client certificate forwarded by a proxy. The default value is 'X-Forwarded-SSL-Certificate'. Another commonly used value is 'X-Forwarded-SSL-Client-Cert'.")
        public String ssl_forward_cert_header() default "X-Forwarded-SSL-Certificate";

        @AttributeDefinition(name="Rewrite Absolute URLs", description="If enabled, absolute URLs passed to either sendRedirect or by setting the location header are rewritten as well.")
        public boolean rewrite_absolute_urls() default false;
    }
}

