/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.systemready.impl.servlet;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.systemready.StateType;
import org.apache.felix.systemready.SystemReadyMonitor;
import org.apache.felix.systemready.impl.servlet.StatusReporter;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.felix.systemready.impl.servlet.SystemReadyServlet", service={Servlet.class}, property={"osgi.http.whiteboard.servlet.pattern=/systemready"})
@Designate(ocd=Config.class)
public class SystemReadyServlet
extends HttpServlet {
    public static final String PID = "org.apache.felix.systemready.impl.servlet.SystemReadyServlet";
    public static final String DEFAULT_PATH = "/systemready";
    private static final Logger LOG = LoggerFactory.getLogger(SystemReadyServlet.class);
    private static final long serialVersionUID = 1L;
    @Reference
    private SystemReadyMonitor monitor;
    private StatusReporter reporter;

    @Activate
    protected void activate(BundleContext ctx, Map<String, Object> properties, Config config) {
        String path = config.osgi_http_whiteboard_servlet_pattern();
        LOG.info("Registered servlet to listen on {}", (Object)path);
        this.reporter = new StatusReporter(this.monitor, StateType.READY);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.reporter.reportState(response);
    }

    @ObjectClassDefinition(name="System Ready Servlet", description="Servlet exposing a http endpoint for retrieving the ready status")
    public static @interface Config {
        @AttributeDefinition(name="Servlet Path")
        public String osgi_http_whiteboard_servlet_pattern() default "/systemready";

        @AttributeDefinition(name="Servlet Context select")
        public String osgi_http_whiteboard_context_select();
    }
}

