/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.units;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.CharStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.flex.abc.ABCEmitter;
import org.apache.flex.abc.semantics.Name;
import org.apache.flex.compiler.common.DependencyType;
import org.apache.flex.compiler.css.ICSSDocument;
import org.apache.flex.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.flex.compiler.definitions.references.ReferenceFactory;
import org.apache.flex.compiler.filespecs.IFileSpecification;
import org.apache.flex.compiler.internal.css.CSSDocument;
import org.apache.flex.compiler.internal.css.codegen.CSSCompilationSession;
import org.apache.flex.compiler.internal.css.codegen.CSSModuleGenerator;
import org.apache.flex.compiler.internal.definitions.ClassDefinition;
import org.apache.flex.compiler.internal.definitions.NamespaceDefinition;
import org.apache.flex.compiler.internal.embedding.EmbedData;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.projects.DefinitionPriority;
import org.apache.flex.compiler.internal.projects.FlexProject;
import org.apache.flex.compiler.internal.scopes.ASFileScope;
import org.apache.flex.compiler.internal.units.CompilationUnitBase;
import org.apache.flex.compiler.internal.units.requests.ABCBytesRequestResult;
import org.apache.flex.compiler.internal.units.requests.FileScopeRequestResultBase;
import org.apache.flex.compiler.internal.units.requests.SWFTagsRequestResult;
import org.apache.flex.compiler.internal.units.requests.SyntaxTreeRequestResult;
import org.apache.flex.compiler.problems.CSSCodeGenProblem;
import org.apache.flex.compiler.problems.FileNotFoundProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.scopes.IASScope;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.compiler.units.requests.IABCBytesRequestResult;
import org.apache.flex.compiler.units.requests.IFileScopeRequestResult;
import org.apache.flex.compiler.units.requests.IOutgoingDependenciesRequestResult;
import org.apache.flex.compiler.units.requests.ISWFTagsRequestResult;
import org.apache.flex.compiler.units.requests.ISyntaxTreeRequestResult;

public class StyleModuleCompilationUnit
extends CompilationUnitBase {
    private final String swfTagName;
    private final IFileSpecification cssFile;

    public StyleModuleCompilationUnit(CompilerProject project, IFileSpecification cssFile, DefinitionPriority.BasePriority basePriority) {
        super(project, cssFile.getPath(), basePriority, false);
        this.swfTagName = FilenameUtils.getBaseName((String)cssFile.getPath());
        this.cssFile = cssFile;
    }

    @Override
    public ICompilationUnit.UnitType getCompilationUnitType() {
        return ICompilationUnit.UnitType.CSS_UNIT;
    }

    @Override
    protected ISyntaxTreeRequestResult handleSyntaxTreeRequest() throws InterruptedException {
        ArrayList<ICompilerProblem> syntaxErrors = new ArrayList<ICompilerProblem>();
        CSSDocument css = null;
        try {
            ANTLRFileStream fileStream = new ANTLRFileStream(this.cssFile.getPath());
            css = CSSDocument.parse((CharStream)fileStream, syntaxErrors);
        }
        catch (IOException e) {
            FileNotFoundProblem problem = new FileNotFoundProblem(this.cssFile.getPath());
            syntaxErrors.add(problem);
        }
        return new StyleModuleSyntaxTreeRequestResult(css, syntaxErrors, this.cssFile.getLastModified());
    }

    @Override
    protected IFileScopeRequestResult handleFileScopeRequest() throws InterruptedException {
        ASFileScope fileScope = new ASFileScope(this.getProject().getWorkspace(), this.cssFile.getPath());
        ClassDefinition classDefinition = new ClassDefinition("CSSModule2Main", NamespaceDefinition.createPackagePublicNamespaceDefinition(""));
        fileScope.addDefinition(classDefinition);
        return new FileScopeRequestResultBase(Collections.<ICompilerProblem>emptySet(), (Collection<? extends IASScope>)ImmutableSet.of((Object)fileScope));
    }

    @Override
    protected IABCBytesRequestResult handleABCBytesRequest() throws InterruptedException {
        StyleModuleSemanticRequestResult semanticResult = (StyleModuleSemanticRequestResult)this.getOutgoingDependenciesRequest().get();
        ABCEmitter emitter = new ABCEmitter();
        emitter.visit(46, 16);
        FlexProject project = (FlexProject)this.getProject();
        ArrayList<CSSCodeGenProblem> problems = new ArrayList<CSSCodeGenProblem>();
        byte[] bytes = null;
        try {
            String moduleName = "CSSModule2";
            Name mainClassName = new Name("CSSModule2Main");
            CSSModuleGenerator.generateMainClass(emitter, project, mainClassName);
            Name styleDataClassName = new Name("CSSModule2_StyleData");
            CSSModuleGenerator.generateStyleDataClass(emitter, project, semanticResult.cssDocument, semanticResult.cssCompilationSession, styleDataClassName);
            bytes = emitter.emit();
        }
        catch (Exception e) {
            CSSCodeGenProblem problem = new CSSCodeGenProblem(e);
            problems.add(problem);
        }
        return new ABCBytesRequestResult(bytes, problems.toArray(new ICompilerProblem[0]), Collections.<EmbedData>emptySet());
    }

    @Override
    protected ISWFTagsRequestResult handleSWFTagsRequest() throws InterruptedException {
        IABCBytesRequestResult abcResult = this.getABCBytesRequest().get();
        return new SWFTagsRequestResult(abcResult.getABCBytes(), this.swfTagName);
    }

    @Override
    protected IOutgoingDependenciesRequestResult handleOutgoingDependenciesRequest() throws InterruptedException {
        StyleModuleSyntaxTreeRequestResult syntaxResult = (StyleModuleSyntaxTreeRequestResult)this.getSyntaxTreeRequest().get();
        ArrayList<ICompilerProblem> cssSemanticProblems = new ArrayList<ICompilerProblem>();
        CSSCompilationSession session = new CSSCompilationSession();
        if (syntaxResult.cssDocument != null) {
            FlexProject flexProject = (FlexProject)this.getProject();
            this.updateStyleCompilationUnitDependencies(session, flexProject, (Iterable<ICSSDocument>)ImmutableList.of((Object)syntaxResult.cssDocument), cssSemanticProblems);
            IResolvedQualifiersReference styleModuleBaseClassRef = ReferenceFactory.packageQualifiedReference(this.getProject().getWorkspace(), "StyleModuleBase");
            styleModuleBaseClassRef.resolve(flexProject, this, DependencyType.INHERITANCE);
        }
        return new StyleModuleSemanticRequestResult(syntaxResult.cssDocument, session, cssSemanticProblems);
    }

    private static class StyleModuleSemanticRequestResult
    implements IOutgoingDependenciesRequestResult {
        private final ICSSDocument cssDocument;
        private final CSSCompilationSession cssCompilationSession;
        private final Collection<ICompilerProblem> semanticProblems;

        private StyleModuleSemanticRequestResult(ICSSDocument cssDocument, CSSCompilationSession cssCompilationSession, Collection<ICompilerProblem> semanticProblems) {
            this.cssDocument = cssDocument;
            this.cssCompilationSession = cssCompilationSession;
            this.semanticProblems = semanticProblems;
        }

        @Override
        public ICompilerProblem[] getProblems() {
            return this.semanticProblems.toArray(new ICompilerProblem[0]);
        }
    }

    private static class StyleModuleSyntaxTreeRequestResult
    extends SyntaxTreeRequestResult {
        private final ICSSDocument cssDocument;

        private StyleModuleSyntaxTreeRequestResult(ICSSDocument cssDocument, Collection<ICompilerProblem> syntaxProblems, long lastModified) {
            super(lastModified, syntaxProblems);
            this.cssDocument = cssDocument;
        }
    }
}

