/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.format;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.format.FileFormatFactory;
import org.apache.flink.table.store.format.FileStatsExtractor;
import org.apache.flink.table.types.logical.RowType;

public abstract class FileFormat {
    protected String formatIdentifier;

    protected FileFormat(String formatIdentifier) {
        this.formatIdentifier = formatIdentifier;
    }

    public String getFormatIdentifier() {
        return this.formatIdentifier;
    }

    public abstract BulkFormat<RowData, FileSourceSplit> createReaderFactory(RowType var1, int[][] var2, List<Predicate> var3);

    public abstract BulkWriter.Factory<RowData> createWriterFactory(RowType var1);

    public BulkFormat<RowData, FileSourceSplit> createReaderFactory(RowType rowType) {
        int[][] projection = new int[rowType.getFieldCount()][];
        for (int i = 0; i < projection.length; ++i) {
            projection[i] = new int[]{i};
        }
        return this.createReaderFactory(rowType, projection);
    }

    public BulkFormat<RowData, FileSourceSplit> createReaderFactory(RowType rowType, int[][] projection) {
        return this.createReaderFactory(rowType, projection, new ArrayList<Predicate>());
    }

    public Optional<FileStatsExtractor> createStatsExtractor(RowType type) {
        return Optional.empty();
    }

    public static FileFormat fromTableOptions(Configuration tableOptions, ConfigOption<String> formatOption) {
        String formatIdentifier = tableOptions.get(formatOption);
        DelegatingConfiguration formatOptions = new DelegatingConfiguration(tableOptions, formatIdentifier + ".");
        return FileFormat.fromIdentifier(formatIdentifier, formatOptions);
    }

    public static FileFormat fromIdentifier(String identifier, Configuration options) {
        Optional<FileFormat> format = FileFormat.fromIdentifier(identifier, options, Thread.currentThread().getContextClassLoader());
        return format.orElseGet(() -> FileFormat.fromIdentifier(identifier, options, FileFormat.class.getClassLoader()).orElseThrow(() -> new ValidationException(String.format("Could not find any factories that implement '%s' in the classpath.", FileFormatFactory.class.getName()))));
    }

    private static Optional<FileFormat> fromIdentifier(String formatIdentifier, Configuration formatOptions, ClassLoader classLoader) {
        ServiceLoader<FileFormatFactory> serviceLoader = ServiceLoader.load(FileFormatFactory.class, classLoader);
        for (FileFormatFactory factory : serviceLoader) {
            if (!factory.identifier().equals(formatIdentifier.toLowerCase())) continue;
            return Optional.of(factory.create(formatOptions));
        }
        return Optional.empty();
    }
}

