/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.format.orc;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.store.format.orc.OrcShimImpl;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.OrcFilters;
import org.apache.flink.table.store.utils.ReflectionUtils;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;

public class OrcInputFormatFactory {
    public static BulkFormat<RowData, FileSourceSplit> create(Configuration conf, RowType type, int[] projection, List<OrcFilters.Predicate> orcPredicates) {
        try {
            return OrcInputFormatFactory.createFrom115(conf, type, projection, orcPredicates);
        }
        catch (ClassNotFoundException e) {
            try {
                return OrcInputFormatFactory.createFrom114(conf, type, projection, orcPredicates);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static BulkFormat<RowData, FileSourceSplit> createFrom115(Configuration conf, RowType type, int[] projection, List<OrcFilters.Predicate> orcPredicates) throws ClassNotFoundException {
        Class<?> formatClass = Class.forName("org.apache.flink.table.store.shaded.org.apache.flink.orc.OrcColumnarRowInputFormat");
        try {
            return (BulkFormat)ReflectionUtils.invokeStaticMethod(formatClass, "createPartitionedFormat", new OrcShimImpl(), conf, type, Collections.emptyList(), null, projection, orcPredicates, 2048, InternalTypeInfo::of);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static BulkFormat<RowData, FileSourceSplit> createFrom114(Configuration conf, RowType type, int[] projection, List<OrcFilters.Predicate> orcPredicates) throws ClassNotFoundException {
        Class<?> formatClass = Class.forName("org.apache.flink.table.store.shaded.org.apache.flink.orc.OrcColumnarRowFileInputFormat");
        try {
            return (BulkFormat)ReflectionUtils.invokeStaticMethod(formatClass, "createPartitionedFormat", new OrcShimImpl(), conf, type, Collections.emptyList(), null, projection, orcPredicates, 2048);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

