/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;

public class Flags
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6243590407214169028L;
    private int system_flags;
    private final Hashtable<String, String> user_flags;

    public Flags() {
        this.user_flags = new Hashtable();
    }

    public Flags(Flag flag) {
        this.system_flags = flag.mask;
        this.user_flags = new Hashtable();
    }

    public Flags(Flags flags) {
        this.system_flags = flags.system_flags;
        this.user_flags = new Hashtable<String, String>(flags.user_flags);
    }

    public Flags(String name) {
        this.user_flags = new Hashtable();
        this.user_flags.put(name.toLowerCase(), name);
    }

    public void add(Flag flag) {
        this.system_flags |= flag.mask;
    }

    public void add(Flags flags) {
        this.system_flags |= flags.system_flags;
        this.user_flags.putAll(flags.user_flags);
    }

    public void add(String name) {
        this.user_flags.put(name.toLowerCase(), name);
    }

    public Object clone() {
        return new Flags(this);
    }

    public boolean contains(Flag flag) {
        return (this.system_flags & flag.mask) != 0;
    }

    public boolean contains(Flags flags) {
        return (this.system_flags & flags.system_flags) == flags.system_flags && this.user_flags.keySet().containsAll(flags.user_flags.keySet());
    }

    public boolean contains(String name) {
        return this.user_flags.containsKey(name.toLowerCase());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Flags)) {
            return false;
        }
        Flags flags = (Flags)other;
        return this.system_flags == flags.system_flags && this.user_flags.keySet().equals(flags.user_flags.keySet());
    }

    public int hashCode() {
        return this.system_flags ^ this.user_flags.keySet().hashCode();
    }

    public Flag[] getSystemFlags() {
        int size = 0;
        if ((this.system_flags & Flag.ANSWERED.mask) != 0) {
            ++size;
        }
        if ((this.system_flags & Flag.DELETED.mask) != 0) {
            ++size;
        }
        if ((this.system_flags & Flag.DRAFT.mask) != 0) {
            ++size;
        }
        if ((this.system_flags & Flag.FLAGGED.mask) != 0) {
            ++size;
        }
        if ((this.system_flags & Flag.RECENT.mask) != 0) {
            ++size;
        }
        if ((this.system_flags & Flag.SEEN.mask) != 0) {
            ++size;
        }
        if ((this.system_flags & Flag.USER.mask) != 0) {
            ++size;
        }
        Flag[] result = new Flag[size];
        if ((this.system_flags & Flag.USER.mask) != 0) {
            result[--size] = Flag.USER;
        }
        if ((this.system_flags & Flag.SEEN.mask) != 0) {
            result[--size] = Flag.SEEN;
        }
        if ((this.system_flags & Flag.RECENT.mask) != 0) {
            result[--size] = Flag.RECENT;
        }
        if ((this.system_flags & Flag.FLAGGED.mask) != 0) {
            result[--size] = Flag.FLAGGED;
        }
        if ((this.system_flags & Flag.DRAFT.mask) != 0) {
            result[--size] = Flag.DRAFT;
        }
        if ((this.system_flags & Flag.DELETED.mask) != 0) {
            result[--size] = Flag.DELETED;
        }
        if ((this.system_flags & Flag.ANSWERED.mask) != 0) {
            result[--size] = Flag.ANSWERED;
        }
        return result;
    }

    public String[] getUserFlags() {
        return this.user_flags.values().toArray(new String[this.user_flags.values().size()]);
    }

    public void remove(Flag flag) {
        this.system_flags &= ~flag.mask;
    }

    public void remove(Flags flags) {
        this.system_flags &= ~flags.system_flags;
        this.user_flags.keySet().removeAll(flags.user_flags.keySet());
    }

    public void remove(String name) {
        this.user_flags.remove(name.toLowerCase());
    }

    public boolean retainAll(Flags f) {
        boolean changed = false;
        if (this.system_flags != f.system_flags) {
            this.system_flags = f.system_flags;
            changed = true;
        }
        HashSet<String> keys = new HashSet<String>(this.user_flags.keySet());
        for (String user_flag : keys) {
            if (f.user_flags.containsKey(user_flag)) continue;
            this.user_flags.remove(user_flag);
            changed = true;
        }
        return changed;
    }

    public void clearSystemFlags() {
        this.system_flags = 0;
    }

    public void clearUserFlags() {
        this.user_flags.clear();
    }

    public static final class Flag {
        public static final Flag ANSWERED = new Flag(1);
        public static final Flag DELETED = new Flag(2);
        public static final Flag DRAFT = new Flag(4);
        public static final Flag FLAGGED = new Flag(8);
        public static final Flag RECENT = new Flag(16);
        public static final Flag SEEN = new Flag(32);
        public static final Flag USER = new Flag(Integer.MIN_VALUE);
        private final int mask;

        private Flag(int mask) {
            this.mask = mask;
        }
    }
}

