/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.subjects;

import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.observers.DeferredScalarDisposable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.concurrent.atomic.AtomicReference;

public final class AsyncSubject<T>
extends Subject<T> {
    static final AsyncDisposable[] EMPTY = new AsyncDisposable[0];
    static final AsyncDisposable[] TERMINATED = new AsyncDisposable[0];
    final AtomicReference<AsyncDisposable<T>[]> subscribers = new AtomicReference<AsyncDisposable[]>(EMPTY);
    Throwable error;
    T value;

    @CheckReturnValue
    @NonNull
    public static <T> AsyncSubject<T> create() {
        return new AsyncSubject<T>();
    }

    AsyncSubject() {
    }

    @Override
    public void onSubscribe(Disposable d) {
        if (this.subscribers.get() == TERMINATED) {
            d.dispose();
        }
    }

    @Override
    public void onNext(T t) {
        ExceptionHelper.nullCheck(t, "onNext called with a null value.");
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        this.value = t;
    }

    @Override
    public void onError(Throwable t) {
        ExceptionHelper.nullCheck(t, "onError called with a null Throwable.");
        if (this.subscribers.get() == TERMINATED) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.value = null;
        this.error = t;
        for (AsyncDisposable as : this.subscribers.getAndSet(TERMINATED)) {
            as.onError(t);
        }
    }

    @Override
    public void onComplete() {
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        T v = this.value;
        AsyncDisposable[] array = this.subscribers.getAndSet(TERMINATED);
        if (v == null) {
            for (AsyncDisposable as : array) {
                as.onComplete();
            }
        } else {
            for (AsyncDisposable as : array) {
                as.complete(v);
            }
        }
    }

    @Override
    @CheckReturnValue
    public boolean hasObservers() {
        return this.subscribers.get().length != 0;
    }

    @Override
    @CheckReturnValue
    public boolean hasThrowable() {
        return this.subscribers.get() == TERMINATED && this.error != null;
    }

    @Override
    @CheckReturnValue
    public boolean hasComplete() {
        return this.subscribers.get() == TERMINATED && this.error == null;
    }

    @Override
    @CheckReturnValue
    public Throwable getThrowable() {
        return this.subscribers.get() == TERMINATED ? this.error : null;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        AsyncDisposable<T> as = new AsyncDisposable<T>(observer, this);
        observer.onSubscribe(as);
        if (this.add(as)) {
            if (as.isDisposed()) {
                this.remove(as);
            }
        } else {
            Throwable ex = this.error;
            if (ex != null) {
                observer.onError(ex);
            } else {
                T v = this.value;
                if (v != null) {
                    as.complete(v);
                } else {
                    as.onComplete();
                }
            }
        }
    }

    boolean add(AsyncDisposable<T> ps) {
        AsyncDisposable[] b;
        AsyncDisposable<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new AsyncDisposable[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = ps;
        } while (!this.subscribers.compareAndSet(a, b));
        return true;
    }

    void remove(AsyncDisposable<T> ps) {
        AsyncDisposable[] b;
        AsyncDisposable<T>[] a;
        do {
            int n;
            if ((n = (a = this.subscribers.get()).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != ps) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY;
                continue;
            }
            b = new AsyncDisposable[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!this.subscribers.compareAndSet(a, b));
    }

    @CheckReturnValue
    public boolean hasValue() {
        return this.subscribers.get() == TERMINATED && this.value != null;
    }

    @CheckReturnValue
    @Nullable
    public T getValue() {
        return this.subscribers.get() == TERMINATED ? (T)this.value : null;
    }

    static final class AsyncDisposable<T>
    extends DeferredScalarDisposable<T> {
        private static final long serialVersionUID = 5629876084736248016L;
        final AsyncSubject<T> parent;

        AsyncDisposable(Observer<? super T> actual, AsyncSubject<T> parent) {
            super(actual);
            this.parent = parent;
        }

        @Override
        public void dispose() {
            if (super.tryDispose()) {
                this.parent.remove(this);
            }
        }

        void onComplete() {
            if (!this.isDisposed()) {
                this.downstream.onComplete();
            }
        }

        void onError(Throwable t) {
            if (this.isDisposed()) {
                RxJavaPlugins.onError(t);
            } else {
                this.downstream.onError(t);
            }
        }
    }
}

