/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.observation;

import io.micrometer.core.instrument.Tag;
import io.micrometer.observation.ObservationPredicate;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import org.apache.hc.core5.util.Args;

public final class ObservingOptions {
    public final EnumSet<MetricSet> metricSets;
    public final TagLevel tagLevel;
    public final ObservationPredicate micrometerFilter;
    public final Predicate<String> spanSampling;
    public final TagCustomizer tagCustomizer;
    public static final ObservingOptions DEFAULT = ObservingOptions.builder().build();

    public static EnumSet<MetricSet> allMetricSets() {
        return EnumSet.allOf(MetricSet.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    private ObservingOptions(Builder b) {
        this.metricSets = b.sets;
        this.tagLevel = b.tag;
        this.micrometerFilter = b.obs;
        this.spanSampling = b.span;
        this.tagCustomizer = b.customizer;
    }

    public static final class Builder {
        private EnumSet<MetricSet> sets = EnumSet.of(MetricSet.BASIC);
        private TagLevel tag = TagLevel.LOW;
        private ObservationPredicate obs = (n, c) -> true;
        private Predicate<String> span = uri -> true;
        private TagCustomizer customizer = (base, m, s, p, t, u) -> base;

        public Builder metrics(EnumSet<MetricSet> s) {
            this.sets = EnumSet.copyOf(s);
            return this;
        }

        public Builder tagLevel(TagLevel t) {
            this.tag = (TagLevel)((Object)Args.notNull((Object)((Object)t), (String)"tag"));
            return this;
        }

        public Builder micrometerFilter(ObservationPredicate p) {
            this.obs = (ObservationPredicate)Args.notNull((Object)p, (String)"pred");
            return this;
        }

        public Builder spanSampling(Predicate<String> p) {
            this.span = (Predicate)Args.notNull(p, (String)"pred");
            return this;
        }

        public Builder tagCustomizer(TagCustomizer c) {
            this.customizer = (TagCustomizer)Args.notNull((Object)c, (String)"tagCustomizer");
            return this;
        }

        public ObservingOptions build() {
            return new ObservingOptions(this);
        }
    }

    @FunctionalInterface
    public static interface TagCustomizer {
        public List<Tag> apply(List<Tag> var1, String var2, int var3, String var4, String var5, String var6);
    }

    public static enum TagLevel {
        LOW,
        EXTENDED;

    }

    public static enum MetricSet {
        BASIC,
        IO,
        CONN_POOL,
        TLS,
        DNS;

    }
}

