/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.concurrent.FutureContribution;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.command.RequestExecutionCommand;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.http.nio.support.BasicClientExchangeHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Asserts;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public final class ClientSessionEndpoint
implements ModalCloseable {
    private final IOSession ioSession;
    private final AtomicBoolean closed;

    public ClientSessionEndpoint(IOSession ioSession) {
        this.ioSession = ioSession;
        this.closed = new AtomicBoolean(false);
    }

    public void execute(Command command, Command.Priority priority) {
        this.ioSession.enqueue(command, priority);
        if (!this.ioSession.isOpen()) {
            command.cancel();
        }
    }

    public void execute(AsyncClientExchangeHandler exchangeHandler, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, HttpContext context) {
        Asserts.check((!this.closed.get() ? 1 : 0) != 0, (String)"Connection is already closed");
        RequestExecutionCommand executionCommand = new RequestExecutionCommand(exchangeHandler, pushHandlerFactory, null, context);
        this.ioSession.enqueue((Command)executionCommand, Command.Priority.NORMAL);
        if (!this.ioSession.isOpen()) {
            exchangeHandler.failed((Exception)new ConnectionClosedException());
        }
    }

    public void execute(AsyncClientExchangeHandler exchangeHandler, HttpContext context) {
        this.execute(exchangeHandler, null, context);
    }

    public <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, HttpContext context, FutureCallback<T> callback) {
        Asserts.check((!this.closed.get() ? 1 : 0) != 0, (String)"Connection is already closed");
        final BasicFuture future = new BasicFuture(callback);
        this.execute((AsyncClientExchangeHandler)new BasicClientExchangeHandler(requestProducer, responseConsumer, (FutureCallback)new FutureContribution<T>(future){

            public void completed(T result) {
                future.completed(result);
            }
        }), pushHandlerFactory, context);
        return future;
    }

    public <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        return this.execute(requestProducer, responseConsumer, null, context, callback);
    }

    public <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        return this.execute(requestProducer, responseConsumer, null, null, callback);
    }

    public boolean isOpen() {
        return !this.closed.get() && this.ioSession.isOpen();
    }

    public void close(CloseMode closeMode) {
        if (this.closed.compareAndSet(false, true)) {
            if (closeMode == CloseMode.GRACEFUL) {
                this.ioSession.enqueue((Command)ShutdownCommand.GRACEFUL, Command.Priority.NORMAL);
            } else {
                this.ioSession.close(closeMode);
            }
        }
    }

    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.ioSession.enqueue((Command)ShutdownCommand.GRACEFUL, Command.Priority.IMMEDIATE);
        }
    }

    public String toString() {
        return this.ioSession.toString();
    }
}

