/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.impl.IncomingEntityDetails;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

class IncomingEntityDetailsTest {
    IncomingEntityDetailsTest() {
    }

    @Test
    void getContentLengthEmpty() {
        HeaderGroup messageHeaders = new HeaderGroup();
        IncomingEntityDetails incomingEntityDetails = new IncomingEntityDetails((MessageHeaders)messageHeaders);
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((long)-1L, (long)incomingEntityDetails.getContentLength()), () -> Assertions.assertNull((Object)incomingEntityDetails.getContentType()), () -> Assertions.assertNull((Object)incomingEntityDetails.getContentEncoding()), () -> Assertions.assertEquals((int)0, (int)incomingEntityDetails.getTrailerNames().size())});
    }

    @Test
    void messageHeadersNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new IncomingEntityDetails(null), (String)"Message Header Null");
    }

    @Test
    void getContentLength() {
        HeaderGroup messageHeaders = new HeaderGroup();
        HeaderGroup headerGroup = new HeaderGroup();
        BasicHeader header = new BasicHeader("name", (Object)"value");
        headerGroup.addHeader((Header)header);
        IncomingEntityDetails incomingEntityDetails = new IncomingEntityDetails((MessageHeaders)messageHeaders);
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((long)-1L, (long)incomingEntityDetails.getContentLength()), () -> Assertions.assertTrue((boolean)incomingEntityDetails.isChunked())});
    }

    @Test
    void getTrailerNames() {
        HeaderGroup messageHeaders = new HeaderGroup();
        BasicHeader header = new BasicHeader("Trailer", (Object)"a, b, c, c");
        messageHeaders.setHeaders(new Header[]{header});
        IncomingEntityDetails incomingEntityDetails = new IncomingEntityDetails((MessageHeaders)messageHeaders);
        Set incomingSet = incomingEntityDetails.getTrailerNames();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertFalse((boolean)incomingSet.isEmpty()), () -> Assertions.assertTrue((boolean)incomingSet.containsAll(Stream.of("a", "b", "c").collect(Collectors.toCollection(HashSet::new))))});
    }
}

