/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicLineFormatter;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestBasicLineFormatter {
    private BasicLineFormatter formatter;

    TestBasicLineFormatter() {
    }

    @BeforeEach
    void setup() {
        this.formatter = BasicLineFormatter.INSTANCE;
    }

    @Test
    void testHttpVersionFormatting() {
        CharArrayBuffer buf = new CharArrayBuffer(64);
        this.formatter.formatProtocolVersion(buf, (ProtocolVersion)HttpVersion.HTTP_1_1);
        Assertions.assertEquals((Object)"HTTP/1.1", (Object)buf.toString());
    }

    @Test
    void testRLFormatting() {
        RequestLine requestline = new RequestLine(Method.GET.name(), "/stuff", (ProtocolVersion)HttpVersion.HTTP_1_1);
        CharArrayBuffer buf = new CharArrayBuffer(64);
        this.formatter.formatRequestLine(buf, requestline);
        Assertions.assertEquals((Object)"GET /stuff HTTP/1.1", (Object)buf.toString());
    }

    @Test
    void testRLFormattingInvalidInput() {
        CharArrayBuffer buf = new CharArrayBuffer(64);
        RequestLine requestline = new RequestLine(Method.GET.name(), "/stuff", (ProtocolVersion)HttpVersion.HTTP_1_1);
        Assertions.assertThrows(NullPointerException.class, () -> this.formatter.formatRequestLine(null, requestline));
        Assertions.assertThrows(NullPointerException.class, () -> this.formatter.formatRequestLine(buf, null));
    }

    @Test
    void testSLFormatting() {
        CharArrayBuffer buf = new CharArrayBuffer(64);
        StatusLine statusline1 = new StatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        this.formatter.formatStatusLine(buf, statusline1);
        Assertions.assertEquals((Object)"HTTP/1.1 200 OK", (Object)buf.toString());
        buf.clear();
        StatusLine statusline2 = new StatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, null);
        this.formatter.formatStatusLine(buf, statusline2);
        Assertions.assertEquals((Object)"HTTP/1.1 200 ", (Object)buf.toString());
    }

    @Test
    void testSLFormattingInvalidInput() {
        CharArrayBuffer buf = new CharArrayBuffer(64);
        StatusLine statusline = new StatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Assertions.assertThrows(NullPointerException.class, () -> this.formatter.formatStatusLine(null, statusline));
        Assertions.assertThrows(NullPointerException.class, () -> this.formatter.formatStatusLine(buf, null));
    }

    @Test
    void testHeaderFormatting() {
        CharArrayBuffer buf = new CharArrayBuffer(64);
        BasicHeader header1 = new BasicHeader("name", (Object)"value");
        this.formatter.formatHeader(buf, (Header)header1);
        Assertions.assertEquals((Object)"name: value", (Object)buf.toString());
        buf.clear();
        BasicHeader header2 = new BasicHeader("name", null);
        this.formatter.formatHeader(buf, (Header)header2);
        Assertions.assertEquals((Object)"name: ", (Object)buf.toString());
    }

    @Test
    void testHeaderFormattingInvalidInput() {
        CharArrayBuffer buf = new CharArrayBuffer(64);
        BasicHeader header = new BasicHeader("name", (Object)"value");
        Assertions.assertThrows(NullPointerException.class, () -> this.lambda$testHeaderFormattingInvalidInput$4((Header)header));
        Assertions.assertThrows(NullPointerException.class, () -> this.formatter.formatHeader(buf, null));
    }

    @Test
    void testHeaderFormattingRequestSplitting() {
        CharArrayBuffer buf = new CharArrayBuffer(64);
        BasicHeader header = new BasicHeader("Host", (Object)"apache.org\r\nOops: oops");
        this.formatter.formatHeader(buf, (Header)header);
        String s = buf.toString();
        Assertions.assertFalse((boolean)s.contains("\n"));
        Assertions.assertEquals((Object)"Host: apache.org  Oops: oops", (Object)s);
    }

    private /* synthetic */ void lambda$testHeaderFormattingInvalidInput$4(Header header) throws Throwable {
        this.formatter.formatHeader(null, header);
    }
}

