/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.managers.systemview.walker;

import java.util.Date;
import java.util.UUID;
import org.apache.ignite.spi.systemview.view.NodeMetricsView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

/**
 * Generated by {@code org.apache.ignite.codegen.SystemViewRowAttributeWalkerGenerator}.
 * {@link NodeMetricsView} attributes walker.
 * 
 * @see NodeMetricsView
 */
public class NodeMetricsViewWalker implements SystemViewRowAttributeWalker<NodeMetricsView> {
    /** {@inheritDoc} */
    @Override public void visitAll(AttributeVisitor v) {
        v.accept(0, "nodeId", UUID.class);
        v.accept(1, "lastUpdateTime", Date.class);
        v.accept(2, "maxActiveJobs", int.class);
        v.accept(3, "curActiveJobs", int.class);
        v.accept(4, "avgActiveJobs", float.class);
        v.accept(5, "maxWaitingJobs", int.class);
        v.accept(6, "curWaitingJobs", int.class);
        v.accept(7, "avgWaitingJobs", float.class);
        v.accept(8, "maxRejectedJobs", int.class);
        v.accept(9, "curRejectedJobs", int.class);
        v.accept(10, "avgRejectedJobs", float.class);
        v.accept(11, "totalRejectedJobs", int.class);
        v.accept(12, "maxCanceledJobs", int.class);
        v.accept(13, "curCanceledJobs", int.class);
        v.accept(14, "avgCanceledJobs", float.class);
        v.accept(15, "totalCanceledJobs", int.class);
        v.accept(16, "maxJobsWaitTime", long.class);
        v.accept(17, "curJobsWaitTime", long.class);
        v.accept(18, "avgJobsWaitTime", long.class);
        v.accept(19, "maxJobsExecuteTime", long.class);
        v.accept(20, "curJobsExecuteTime", long.class);
        v.accept(21, "avgJobsExecuteTime", long.class);
        v.accept(22, "totalJobsExecuteTime", long.class);
        v.accept(23, "totalExecutedJobs", int.class);
        v.accept(24, "totalExecutedTasks", int.class);
        v.accept(25, "totalBusyTime", long.class);
        v.accept(26, "totalIdleTime", long.class);
        v.accept(27, "curIdleTime", long.class);
        v.accept(28, "busyTimePercentage", float.class);
        v.accept(29, "idleTimePercentage", float.class);
        v.accept(30, "totalCpu", int.class);
        v.accept(31, "curCpuLoad", double.class);
        v.accept(32, "avgCpuLoad", double.class);
        v.accept(33, "curGcCpuLoad", double.class);
        v.accept(34, "heapMemoryInit", long.class);
        v.accept(35, "heapMemoryUsed", long.class);
        v.accept(36, "heapMemoryCommited", long.class);
        v.accept(37, "heapMemoryMax", long.class);
        v.accept(38, "heapMemoryTotal", long.class);
        v.accept(39, "nonheapMemoryInit", long.class);
        v.accept(40, "nonheapMemoryUsed", long.class);
        v.accept(41, "nonheapMemoryCommited", long.class);
        v.accept(42, "nonheapMemoryMax", long.class);
        v.accept(43, "nonheapMemoryTotal", long.class);
        v.accept(44, "uptime", long.class);
        v.accept(45, "jvmStartTime", Date.class);
        v.accept(46, "nodeStartTime", Date.class);
        v.accept(47, "lastDataVersion", long.class);
        v.accept(48, "curThreadCount", int.class);
        v.accept(49, "maxThreadCount", int.class);
        v.accept(50, "totalThreadCount", long.class);
        v.accept(51, "curDaemonThreadCount", int.class);
        v.accept(52, "sentMessagesCount", int.class);
        v.accept(53, "sentBytesCount", long.class);
        v.accept(54, "receivedMessagesCount", int.class);
        v.accept(55, "receivedBytesCount", long.class);
        v.accept(56, "outboundMessagesQueue", int.class);
    }

    /** {@inheritDoc} */
    @Override public void visitAll(NodeMetricsView row, AttributeWithValueVisitor v) {
        v.accept(0, "nodeId", UUID.class, row.nodeId());
        v.accept(1, "lastUpdateTime", Date.class, row.lastUpdateTime());
        v.acceptInt(2, "maxActiveJobs", row.maxActiveJobs());
        v.acceptInt(3, "curActiveJobs", row.curActiveJobs());
        v.acceptFloat(4, "avgActiveJobs", row.avgActiveJobs());
        v.acceptInt(5, "maxWaitingJobs", row.maxWaitingJobs());
        v.acceptInt(6, "curWaitingJobs", row.curWaitingJobs());
        v.acceptFloat(7, "avgWaitingJobs", row.avgWaitingJobs());
        v.acceptInt(8, "maxRejectedJobs", row.maxRejectedJobs());
        v.acceptInt(9, "curRejectedJobs", row.curRejectedJobs());
        v.acceptFloat(10, "avgRejectedJobs", row.avgRejectedJobs());
        v.acceptInt(11, "totalRejectedJobs", row.totalRejectedJobs());
        v.acceptInt(12, "maxCanceledJobs", row.maxCanceledJobs());
        v.acceptInt(13, "curCanceledJobs", row.curCanceledJobs());
        v.acceptFloat(14, "avgCanceledJobs", row.avgCanceledJobs());
        v.acceptInt(15, "totalCanceledJobs", row.totalCanceledJobs());
        v.acceptLong(16, "maxJobsWaitTime", row.maxJobsWaitTime());
        v.acceptLong(17, "curJobsWaitTime", row.curJobsWaitTime());
        v.acceptLong(18, "avgJobsWaitTime", row.avgJobsWaitTime());
        v.acceptLong(19, "maxJobsExecuteTime", row.maxJobsExecuteTime());
        v.acceptLong(20, "curJobsExecuteTime", row.curJobsExecuteTime());
        v.acceptLong(21, "avgJobsExecuteTime", row.avgJobsExecuteTime());
        v.acceptLong(22, "totalJobsExecuteTime", row.totalJobsExecuteTime());
        v.acceptInt(23, "totalExecutedJobs", row.totalExecutedJobs());
        v.acceptInt(24, "totalExecutedTasks", row.totalExecutedTasks());
        v.acceptLong(25, "totalBusyTime", row.totalBusyTime());
        v.acceptLong(26, "totalIdleTime", row.totalIdleTime());
        v.acceptLong(27, "curIdleTime", row.curIdleTime());
        v.acceptFloat(28, "busyTimePercentage", row.busyTimePercentage());
        v.acceptFloat(29, "idleTimePercentage", row.idleTimePercentage());
        v.acceptInt(30, "totalCpu", row.totalCpu());
        v.acceptDouble(31, "curCpuLoad", row.curCpuLoad());
        v.acceptDouble(32, "avgCpuLoad", row.avgCpuLoad());
        v.acceptDouble(33, "curGcCpuLoad", row.curGcCpuLoad());
        v.acceptLong(34, "heapMemoryInit", row.heapMemoryInit());
        v.acceptLong(35, "heapMemoryUsed", row.heapMemoryUsed());
        v.acceptLong(36, "heapMemoryCommited", row.heapMemoryCommited());
        v.acceptLong(37, "heapMemoryMax", row.heapMemoryMax());
        v.acceptLong(38, "heapMemoryTotal", row.heapMemoryTotal());
        v.acceptLong(39, "nonheapMemoryInit", row.nonheapMemoryInit());
        v.acceptLong(40, "nonheapMemoryUsed", row.nonheapMemoryUsed());
        v.acceptLong(41, "nonheapMemoryCommited", row.nonheapMemoryCommited());
        v.acceptLong(42, "nonheapMemoryMax", row.nonheapMemoryMax());
        v.acceptLong(43, "nonheapMemoryTotal", row.nonheapMemoryTotal());
        v.acceptLong(44, "uptime", row.uptime());
        v.accept(45, "jvmStartTime", Date.class, row.jvmStartTime());
        v.accept(46, "nodeStartTime", Date.class, row.nodeStartTime());
        v.acceptLong(47, "lastDataVersion", row.lastDataVersion());
        v.acceptInt(48, "curThreadCount", row.curThreadCount());
        v.acceptInt(49, "maxThreadCount", row.maxThreadCount());
        v.acceptLong(50, "totalThreadCount", row.totalThreadCount());
        v.acceptInt(51, "curDaemonThreadCount", row.curDaemonThreadCount());
        v.acceptInt(52, "sentMessagesCount", row.sentMessagesCount());
        v.acceptLong(53, "sentBytesCount", row.sentBytesCount());
        v.acceptInt(54, "receivedMessagesCount", row.receivedMessagesCount());
        v.acceptLong(55, "receivedBytesCount", row.receivedBytesCount());
        v.acceptInt(56, "outboundMessagesQueue", row.outboundMessagesQueue());
    }

    /** {@inheritDoc} */
    @Override public int count() {
        return 57;
    }
}
