/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.util;

import java.util.Comparator;
import java.util.PriorityQueue;

public class BoundedPriorityQueue<E>
extends PriorityQueue<E> {
    private static final long serialVersionUID = 0L;
    private final int maxCap;
    private final Comparator<? super E> cmp;

    public BoundedPriorityQueue(int maxCap, Comparator<? super E> cmp) {
        super(maxCap, cmp);
        if (cmp == null) {
            throw new NullPointerException("comparator should not be null");
        }
        this.maxCap = maxCap;
        this.cmp = cmp;
    }

    @Override
    public boolean offer(E e) {
        if (this.size() >= this.maxCap) {
            Object head = this.peek();
            if (this.cmp.compare(e, head) <= 0) {
                return false;
            }
            this.poll();
        }
        return super.offer(e);
    }
}

