<!--
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
  -->
  
# Articles

This page contains links to the latest articles and presentations on Jackrabbit Oak. 
It is meant as an entry point for any newcommer to Jackrabbit Oak

* Valentin Olteanu, Michael Duerig, [TarMK: Facts and Figures](https://adapt.to/2017/en/schedule/tarmk--facts-and-figures.html)
* Michael Duerig, [Into the tar pit: a TarMK deep dive](https://adapt.to/2016/en/schedule/into-the-tar-pit--a-tarmk-deep-dive.html) (September 2016) adaptTo() 2016
* Michael Duerig, [Avoiding and dealing with conflicting updates in Oak](https://adapt.to/2015/en/schedule/avoiding-and-dealing-with-conflicting-updates-in-oak.html) (September 2015) adaptTo() 2015
* Davide Giannella, [Scaling the query with Oak](https://adapt.to/2015/en/schedule/scaling-the-query-with-oak.html) (September 2015) adaptTo() 2015
* Tommaso Teofili, [Scaling Search in Oak with Solr](https://adapt.to/2013/en/schedule/09_scalingsearch.html) (September 2013) adaptTo() 2013
* Michael Marth, [Oak: an introduction for users](https://adapt.to/2013/en/schedule/03_oakintro.html) (September 2013) adaptTo() 2013
* Tommaso Teofili [Oak / Solr integration](https://adapt.to/2012/en/schedule/oak-solr-integration.html) (September 2012) adaptTo() 2012
* Michael Duerig, Jukka Zitting [Apache Jackrabbit Oak](https://adapt.to/2012/en/schedule/apache-jackrabbit-oak.html) (September 2012) adaptTo() 2012
* [JCR and Jackrabbit related links](http://jackrabbit.apache.org/jcr/articles.html)
* [Oak, the architecture of Apache Jackrabbit 3](http://www.slideshare.net/jukka/oak-the-architecture-of-apache-jackrabbit-3).
* [Oak, the architecture of the new Repository](http://www.slideshare.net/MichaelDrig/oak-39377061)

## Other References

Following links are also useful to search for information which is not documented in current docs

* the [Oak JIRA](https://issues.apache.org/jira/browse/OAK), specifically [OAK-14]
  (https://issues.apache.org/jira/browse/OAK-14), which lists the known backward compatibility issues,
* the [Oak development list](http://jackrabbit.markmail.org/search/+list:org.apache.jackrabbit.oak-dev),
* the [README files](https://github.com/apache/jackrabbit-oak/blob/trunk/README.md)