/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.BenchmarkResultMetaData;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.Multimap;

public class BenchmarkResult
implements Serializable {
    private static final long serialVersionUID = 6467912427356048369L;
    private final Collection<IterationResult> iterationResults;
    private final Multimap<String, Result> benchmarkResults;
    private final BenchmarkParams params;
    private final BenchmarkResultMetaData metadata;

    public BenchmarkResult(BenchmarkParams params, Collection<IterationResult> data) {
        this(params, data, null);
    }

    public BenchmarkResult(BenchmarkParams params, Collection<IterationResult> data, BenchmarkResultMetaData md) {
        this.metadata = md;
        this.benchmarkResults = new HashMultimap<String, Result>();
        this.iterationResults = data;
        this.params = params;
    }

    public BenchmarkResultMetaData getMetadata() {
        return this.metadata;
    }

    public void addBenchmarkResult(Result r) {
        this.benchmarkResults.put(r.getLabel(), r);
    }

    public Collection<IterationResult> getIterationResults() {
        return this.iterationResults;
    }

    public Multimap<String, Result> getBenchmarkResults() {
        return this.benchmarkResults;
    }

    public Result getPrimaryResult() {
        Aggregator aggregator = null;
        ArrayList<Result> aggrs = new ArrayList<Result>();
        for (IterationResult iterationResult : this.iterationResults) {
            Result e = iterationResult.getPrimaryResult();
            aggrs.add(e);
            aggregator = e.getIterationAggregator();
        }
        for (Result result : this.benchmarkResults.values()) {
            if (!result.getRole().isPrimary()) continue;
            aggrs.add(result);
        }
        if (aggregator != null) {
            return aggregator.aggregate(aggrs);
        }
        throw new IllegalStateException("No aggregator for primary result");
    }

    public Map<String, Result> getSecondaryResults() {
        HashMultimap allSecondary = new HashMultimap();
        for (IterationResult ir : this.iterationResults) {
            Iterator<String> secondaryResults = ir.getSecondaryResults();
            for (Map.Entry<String, Result> entry : secondaryResults.entrySet()) {
                if (entry.getValue().getRole().isDerivative()) continue;
                allSecondary.put(entry.getKey(), entry.getValue());
            }
        }
        TreeMap<String, Result> answers = new TreeMap<String, Result>();
        int totalIterations = this.iterationResults.size();
        for (String label : allSecondary.keys()) {
            Aggregator aggregator;
            Collection results = allSecondary.get(label);
            Result firstResult = (Result)results.iterator().next();
            Object emptyResult = firstResult.getZeroResult();
            if (emptyResult != null) {
                for (int i = results.size(); i < totalIterations; ++i) {
                    allSecondary.put(label, emptyResult);
                }
            }
            if ((aggregator = firstResult.getIterationAggregator()) == null) {
                if (results.size() == 1) {
                    answers.put(label, firstResult);
                    continue;
                }
                throw new IllegalStateException("No aggregator for " + firstResult);
            }
            Object aggregate = aggregator.aggregate(allSecondary.get(label));
            answers.put(label, (Result)aggregate);
        }
        for (String label : this.benchmarkResults.keys()) {
            Aggregator aggregator = null;
            ArrayList<Result> results = new ArrayList<Result>();
            for (Result r : this.benchmarkResults.get(label)) {
                if (!r.getRole().isSecondary() || r.getRole().isDerivative()) continue;
                results.add(r);
                aggregator = r.getIterationAggregator();
            }
            if (aggregator == null) continue;
            answers.put(label, (Result)aggregator.aggregate(results));
        }
        answers.putAll(this.produceDerivative(this.getPrimaryResult()));
        HashMap<String, Result> adds = new HashMap<String, Result>();
        for (Result r : answers.values()) {
            adds.putAll(this.produceDerivative(r));
        }
        answers.putAll(adds);
        return answers;
    }

    private Map<String, Result> produceDerivative(Result r) {
        HashMap<String, Result> map = new HashMap<String, Result>();
        for (Result rr : r.getDerivativeResults()) {
            map.put(rr.getLabel(), rr);
        }
        return map;
    }

    public String getScoreUnit() {
        return this.getPrimaryResult().getScoreUnit();
    }

    public BenchmarkParams getParams() {
        return this.params;
    }
}

