/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.util;

import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.util.MimeUtil;

public class MimeParameterMapping {
    private static final Pattern STAR_AND_NUMBER = Pattern.compile("\\*\\d");
    private final Set<String> parameterNames = new HashSet<String>();
    private final Map<String, String> standard = new HashMap<String, String>();
    private final Map<String, String> extended = new HashMap<String, String>();
    private final Map<String, String> continuation = new HashMap<String, String>();
    private final Map<String, String> parameters = new HashMap<String, String>();
    private boolean needToUpdate = true;
    private String charset;

    public Map<String, String> getParameters() {
        if (this.needToUpdate) {
            this.updateParameters();
            this.needToUpdate = false;
        }
        return Collections.unmodifiableMap(this.parameters);
    }

    private void updateParameters() {
        this.parameters.clear();
        for (String param : this.parameterNames) {
            this.parameters.put(param, this.get(param));
        }
    }

    public String get(String name) {
        if (!this.parameterNames.contains(name)) {
            return null;
        }
        if (this.extended.containsKey(name)) {
            try {
                return this.decodeParameterValue(this.extended.get(name));
            }
            catch (DecodeException decodeException) {
                // empty catch block
            }
        }
        if (this.continuation.containsKey(name)) {
            try {
                return this.decodeParameterValue(this.continuation.get(name));
            }
            catch (DecodeException decodeException) {
                // empty catch block
            }
        }
        if (this.standard.containsKey(name)) {
            try {
                return this.decodeParameterValue(this.standard.get(name));
            }
            catch (DecodeException decodeException) {
                // empty catch block
            }
        }
        if (this.standard.containsKey(name)) {
            return this.standard.get(name);
        }
        if (this.continuation.containsKey(name)) {
            return this.continuation.get(name);
        }
        if (this.extended.containsKey(name)) {
            return this.extended.get(name);
        }
        return null;
    }

    public void addParameter(String name, String value) {
        ParameterTypePair parameterTypePair = this.getParameterTypePair(name);
        this.parameterNames.add(parameterTypePair.fieldName);
        this.needToUpdate = true;
        switch (parameterTypePair.fieldType.ordinal()) {
            case 1: {
                this.extended.putIfAbsent(parameterTypePair.fieldName, value);
                break;
            }
            case 2: {
                if (this.continuation.containsKey(parameterTypePair.fieldName)) {
                    String newValue = this.continuation.get(parameterTypePair.fieldName) + value;
                    this.continuation.put(parameterTypePair.fieldName, newValue);
                    break;
                }
                this.continuation.put(parameterTypePair.fieldName, value);
                break;
            }
            case 0: {
                this.standard.putIfAbsent(parameterTypePair.fieldName, value);
            }
        }
    }

    private String decodeParameterValue(String value) throws DecodeException {
        if (value == null) {
            return null;
        }
        int charsetEnd = value.indexOf("'");
        int languageEnd = value.indexOf("'", charsetEnd + 1);
        if (charsetEnd < 0 || languageEnd < 0) {
            if (this.charset != null) {
                return this.urlDecode(value);
            }
            return MimeUtil.unscrambleHeaderValue(value);
        }
        this.charset = value.substring(0, charsetEnd);
        String fileName = value.substring(languageEnd + 1);
        try {
            Charset.forName(this.charset);
        }
        catch (IllegalArgumentException e) {
            return fileName;
        }
        return this.urlDecode(fileName);
    }

    private String urlDecode(String value) throws DecodeException {
        try {
            return URLDecoder.decode(value, this.charset);
        }
        catch (Exception e) {
            throw new DecodeException(e);
        }
    }

    private ParameterTypePair getParameterTypePair(String parameterName) {
        int position = parameterName.indexOf(42);
        if (position < 0) {
            return new ParameterTypePair(parameterName.toLowerCase(Locale.ROOT), PARAMETER_TYPE.STANDARD);
        }
        String fieldName = parameterName.substring(0, position);
        fieldName = fieldName.toLowerCase(Locale.ROOT);
        String starAndAfter = parameterName.substring(position);
        if ("*".equals(starAndAfter)) {
            return new ParameterTypePair(fieldName, PARAMETER_TYPE.EXTENDED);
        }
        Matcher m = STAR_AND_NUMBER.matcher(starAndAfter);
        if (m.find()) {
            return new ParameterTypePair(fieldName, PARAMETER_TYPE.CONTINUATION);
        }
        return new ParameterTypePair(fieldName, PARAMETER_TYPE.EXTENDED);
    }

    private static class DecodeException
    extends MimeException {
        public DecodeException(String message) {
            super(message);
        }

        public DecodeException(Throwable cause) {
            super(cause);
        }

        public DecodeException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class ParameterTypePair {
        private final String fieldName;
        private final PARAMETER_TYPE fieldType;

        public ParameterTypePair(String fieldName, PARAMETER_TYPE fieldType) {
            this.fieldName = fieldName;
            this.fieldType = fieldType;
        }
    }

    static enum PARAMETER_TYPE {
        STANDARD,
        EXTENDED,
        CONTINUATION;

    }
}

