/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.util.Objects;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.impl.WrappedGraph;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExecDataset;
import org.apache.jena.sparql.exec.QueryExecDatasetBuilder;
import org.apache.jena.sparql.exec.QueryExecutionCompat;
import org.apache.jena.sparql.graph.GraphWrapper;
import org.apache.jena.sparql.syntax.Element;

public class QueryExecutionFactory {
    protected QueryExecutionFactory() {
    }

    public static QueryExecution create(Query query) {
        QueryExecutionFactory.checkArg(query);
        return QueryExecutionFactory.makeExecution(query);
    }

    public static QueryExecution create(String queryStr) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr));
    }

    public static QueryExecution create(String queryStr, Syntax syntax) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax));
    }

    public static QueryExecution create(Query query, Dataset dataset) {
        return QueryExecutionFactory.make(query, dataset, null);
    }

    public static QueryExecution create(Query query, DatasetGraph datasetGraph) {
        Objects.requireNonNull(query, "Query is null");
        Objects.requireNonNull(datasetGraph, "DatasetGraph is null");
        return QueryExecutionFactory.make(query, null, datasetGraph);
    }

    public static QueryExecution create(String queryStr, Dataset dataset) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.make(QueryExecutionFactory.makeQuery(queryStr), dataset, null);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, Dataset dataset) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.make(QueryExecutionFactory.makeQuery(queryStr, syntax), dataset, null);
    }

    public static QueryExecution create(Query query, Model model) {
        QueryExecutionFactory.checkArg(query);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.makeExecution(query, model);
    }

    public static QueryExecution create(String queryStr, Model model) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), model);
    }

    public static QueryExecution create(String queryStr, Syntax lang, Model model) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, lang), model);
    }

    @Deprecated(forRemoval=true)
    public static QueryExecution create(Query query, Dataset dataset, QuerySolution querySolution) {
        QueryExecutionFactory.checkArg(query);
        return QueryExecution.dataset(dataset).query(query).substitution(querySolution).build();
    }

    @Deprecated(forRemoval=true)
    public static QueryExecution create(Query query, Model model, QuerySolution querySolution) {
        QueryExecutionFactory.checkArg(query);
        return QueryExecution.model(model).query(query).substitution(querySolution).build();
    }

    private static Query toQuery(Element pattern) {
        Query query = QueryFactory.make();
        query.setQueryPattern(pattern);
        query.setQuerySelectType();
        query.setQueryResultStar(true);
        return query;
    }

    private static Query makeQuery(String queryStr) {
        return QueryFactory.create(queryStr);
    }

    private static Query makeQuery(String queryStr, Syntax syntax) {
        return QueryFactory.create(queryStr, syntax);
    }

    protected static QueryExecution makeExecution(Query query) {
        return QueryExecution.create().query(query).build();
    }

    protected static QueryExecution makeExecution(Query query, Model model) {
        Graph graph = model.getGraph();
        DatasetGraph dataset = DatasetGraphFactory.wrap(graph);
        Graph g = QueryExecutionFactory.unwrap(graph);
        if (g instanceof GraphView) {
            GraphView gv = (GraphView)g;
            dataset.getContext().putAll(gv.getDataset().getContext());
        }
        return QueryExecutionFactory.make(query, null, dataset);
    }

    private static Graph unwrap(Graph graph) {
        while (true) {
            if (graph instanceof GraphWrapper) {
                graph = ((GraphWrapper)graph).get();
                continue;
            }
            if (!(graph instanceof WrappedGraph)) break;
            graph = ((WrappedGraph)graph).getWrapped();
        }
        return graph;
    }

    private static QueryExecution make(Query query, Dataset dataset, DatasetGraph datasetGraph) {
        return QueryExecutionFactory.make$(query, dataset, datasetGraph, null);
    }

    private static QueryExecution make$(Query query, Dataset dataset, DatasetGraph datasetGraph, Binding initialBinding) {
        QueryExecDatasetBuilder builder = QueryExecDataset.newBuilder().query(query);
        if (initialBinding != null) {
            builder.initialBinding(initialBinding);
        }
        if (dataset == null && datasetGraph == null) {
            return QueryExecutionCompat.compatibility(builder, null, query, builder.getQueryString());
        }
        if (dataset == null) {
            builder.dataset(datasetGraph);
            dataset = DatasetFactory.wrap(datasetGraph);
        } else {
            builder.dataset(dataset.asDatasetGraph());
        }
        return QueryExecutionCompat.compatibility(builder, dataset, query, builder.getQueryString());
    }

    private static void checkArg(Model model) {
        Objects.requireNonNull(model, "Model is a null pointer");
    }

    private static void checkArg(String queryStr) {
        Objects.requireNonNull(queryStr, "Query string is null");
    }

    private static void checkArg(Query query) {
        Objects.requireNonNull(query, "Query is null");
    }
}

