/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.Serializable;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.stream.JsonGenerator;

class JsonWriterImpl
implements JsonWriter,
Serializable {
    private final JsonGenerator generator;
    private boolean called = false;
    private boolean closed = false;

    JsonWriterImpl(JsonGenerator generator) {
        this.generator = generator;
    }

    public void writeArray(JsonArray array) {
        this.checkState();
        this.generator.write((JsonValue)array);
        this.markCalled();
    }

    public void writeObject(JsonObject object) {
        this.checkState();
        this.generator.write((JsonValue)object);
        this.markCalled();
    }

    public void write(JsonValue value) {
        this.checkState();
        this.generator.write(value);
        this.markCalled();
    }

    public void write(JsonStructure value) {
        this.checkState();
        this.generator.write((JsonValue)value);
        this.markCalled();
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.generator.close();
        }
    }

    private void markCalled() {
        this.generator.flush();
        this.called = true;
    }

    private void checkState() {
        if (this.closed || this.called) {
            throw new IllegalStateException("writeArray(), writeObject(), write() or close() method was already called");
        }
    }
}

