/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import java.security.Permission;
import org.apache.wiki.api.core.Command;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.auth.GroupPrincipal;
import org.apache.wiki.auth.permissions.GroupPermission;
import org.apache.wiki.ui.AbstractCommand;

public final class GroupCommand
extends AbstractCommand {
    public static final Command DELETE_GROUP = new GroupCommand(ContextEnum.GROUP_DELETE, null, "delete");
    public static final Command EDIT_GROUP = new GroupCommand(ContextEnum.GROUP_EDIT, null, "edit");
    public static final Command VIEW_GROUP = new GroupCommand(ContextEnum.GROUP_VIEW, null, "view");
    private final String m_action;
    private final Permission m_permission;

    private GroupCommand(ContextEnum currentContext, GroupPrincipal target, String action) {
        this(currentContext.getRequestContext(), currentContext.getUrlPattern(), currentContext.getContentTemplate(), target, action);
    }

    private GroupCommand(String requestContext, String urlPattern, String contentTemplate, GroupPrincipal target, String action) {
        super(requestContext, urlPattern, contentTemplate, target);
        this.m_action = action;
        this.m_permission = target == null || this.m_action == null ? null : new GroupPermission(target.getName(), action);
    }

    @Override
    public Command targetedCommand(Object target) {
        if (!(target instanceof GroupPrincipal)) {
            throw new IllegalArgumentException("Target must non-null and of type GroupPrincipal.");
        }
        return new GroupCommand(this.getRequestContext(), this.getURLPattern(), this.getContentTemplate(), (GroupPrincipal)target, this.m_action);
    }

    @Override
    public String getName() {
        Object target = this.getTarget();
        if (target == null) {
            return this.getJSPFriendlyName();
        }
        return ((GroupPrincipal)target).getName();
    }

    public Permission requiredPermission() {
        return this.m_permission;
    }
}

