/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.function.Supplier;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.http.BasicHeader;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializeException;

public class SerializedHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final Object value;
    private HttpPartSerializerSession serializer;
    private HttpPartSchema schema = HttpPartSchema.DEFAULT;
    private boolean skipIfEmpty;

    public static SerializedHeader of(String name, Object value) {
        return new SerializedHeader(name, value, null, null, false);
    }

    public static SerializedHeader of(String name, Supplier<?> value) {
        return new SerializedHeader(name, value, null, null, false);
    }

    public SerializedHeader(String name, Object value, HttpPartSerializerSession serializer, HttpPartSchema schema, boolean skipIfEmpty) {
        super(name, value);
        this.value = value;
        this.serializer = serializer;
        this.schema = schema;
        this.skipIfEmpty = skipIfEmpty;
    }

    public SerializedHeader serializer(HttpPartSerializer value) {
        if (value != null) {
            return this.serializer(value.createPartSession(null));
        }
        return this;
    }

    public SerializedHeader serializer(HttpPartSerializerSession value) {
        return this.serializer(value, true);
    }

    public SerializedHeader serializer(HttpPartSerializerSession value, boolean overwrite) {
        if (overwrite || this.serializer == null) {
            this.serializer = value;
        }
        return this;
    }

    public SerializedHeader schema(HttpPartSchema value) {
        this.schema = value;
        return this;
    }

    public SerializedHeader skipIfEmpty() {
        return this.skipIfEmpty(true);
    }

    public SerializedHeader skipIfEmpty(boolean value) {
        this.skipIfEmpty = value;
        return this;
    }

    @Override
    public String getValue() {
        try {
            Object v = SerializedHeader.unwrap(this.value);
            HttpPartSchema schema = this.schema == null ? HttpPartSchema.DEFAULT : this.schema;
            String def = schema.getDefault();
            if (v == null) {
                if (def == null && !schema.isRequired()) {
                    return null;
                }
                if (def == null && schema.isAllowEmptyValue()) {
                    return null;
                }
            }
            if (StringUtils.isEmpty(v) && this.skipIfEmpty && def == null) {
                return null;
            }
            return this.serializer == null ? StringUtils.stringify(v) : this.serializer.serialize(HttpPartType.HEADER, schema, v);
        }
        catch (SchemaValidationException e) {
            throw new BasicRuntimeException(e, "Validation error on request {0} parameter ''{1}''=''{2}''", new Object[]{HttpPartType.HEADER, this.getName(), this.value});
        }
        catch (SerializeException e) {
            throw new BasicRuntimeException(e, "Serialization error on request {0} parameter ''{1}''", new Object[]{HttpPartType.HEADER, this.getName()});
        }
    }
}

