/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.collections.ASet;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.Items;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.dto.swagger.Xml;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.internal.StringUtils;

@Bean(bpi="format,title,description,default,multipleOf,maximum,exclusiveMaximum,minimum,exclusiveMinimum,maxLength,minLength,pattern,maxItems,minItems,uniqueItems,maxProperties,minProperties,required,enum,type,items,allOf,properties,additionalProperties,discriminator,readOnly,xml,externalDocs,example,$ref,*")
public class SchemaInfo
extends SwaggerElement {
    private String format;
    private String title;
    private String description;
    private String pattern;
    private String type;
    private String discriminator;
    private String ref;
    private Number multipleOf;
    private Number maximum;
    private Number minimum;
    private Integer maxLength;
    private Integer minLength;
    private Integer maxItems;
    private Integer minItems;
    private Integer maxProperties;
    private Integer minProperties;
    private Boolean exclusiveMaximum;
    private Boolean exclusiveMinimum;
    private Boolean uniqueItems;
    private Boolean readOnly;
    private Object _default;
    private Object example;
    private Items items;
    private Xml xml;
    private ExternalDocumentation externalDocs;
    private List<Object> _enum;
    private List<Object> allOf;
    private List<String> required;
    private Map<String, SchemaInfo> properties;
    private SchemaInfo additionalProperties;

    public SchemaInfo() {
    }

    public SchemaInfo(SchemaInfo copyFrom) {
        super(copyFrom);
        this.format = copyFrom.format;
        this.title = copyFrom.title;
        this.description = copyFrom.description;
        this.pattern = copyFrom.pattern;
        this.type = copyFrom.type;
        this.discriminator = copyFrom.discriminator;
        this.ref = copyFrom.ref;
        this.multipleOf = copyFrom.multipleOf;
        this.maximum = copyFrom.maximum;
        this.minimum = copyFrom.minimum;
        this.maxLength = copyFrom.maxLength;
        this.minLength = copyFrom.minLength;
        this.maxItems = copyFrom.maxItems;
        this.minItems = copyFrom.minItems;
        this.maxProperties = copyFrom.maxProperties;
        this.minProperties = copyFrom.minProperties;
        this.exclusiveMaximum = copyFrom.exclusiveMaximum;
        this.exclusiveMinimum = copyFrom.exclusiveMinimum;
        this.uniqueItems = copyFrom.uniqueItems;
        this.readOnly = copyFrom.readOnly;
        this._default = copyFrom._default;
        this.example = copyFrom.example;
        this.items = copyFrom.items == null ? null : copyFrom.items.copy();
        this.xml = copyFrom.xml == null ? null : copyFrom.xml.copy();
        this.externalDocs = copyFrom.externalDocs == null ? null : copyFrom.externalDocs.copy();
        this._enum = CollectionUtils.newList(copyFrom._enum);
        this.allOf = CollectionUtils.newList(copyFrom.allOf);
        this.required = CollectionUtils.newList(copyFrom.required);
        if (copyFrom.properties == null) {
            this.properties = null;
        } else {
            this.properties = new LinkedHashMap<String, SchemaInfo>();
            for (Map.Entry<String, SchemaInfo> e : copyFrom.properties.entrySet()) {
                this.properties.put(e.getKey(), e.getValue().copy());
            }
        }
        this.additionalProperties = copyFrom.additionalProperties == null ? null : copyFrom.additionalProperties.copy();
    }

    public SchemaInfo copy() {
        return new SchemaInfo(this);
    }

    public String getFormat() {
        return this.format;
    }

    public SchemaInfo setFormat(String value) {
        this.format = value;
        return this;
    }

    public SchemaInfo format(Object value) {
        return this.setFormat(StringUtils.stringify(value));
    }

    public String getTitle() {
        return this.title;
    }

    public SchemaInfo setTitle(String value) {
        this.title = value;
        return this;
    }

    public SchemaInfo title(Object value) {
        return this.setTitle(StringUtils.stringify(value));
    }

    public String getDescription() {
        return this.description;
    }

    public SchemaInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public SchemaInfo description(Object value) {
        return this.setDescription(StringUtils.stringify(value));
    }

    public Object getDefault() {
        return this._default;
    }

    public SchemaInfo setDefault(Object value) {
        this._default = value;
        return this;
    }

    public SchemaInfo _default(Object value) {
        return this.setDefault(value);
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public SchemaInfo setMultipleOf(Number value) {
        this.multipleOf = value;
        return this;
    }

    public SchemaInfo multipleOf(Object value) {
        return this.setMultipleOf(ConverterUtils.toNumber(value));
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public SchemaInfo setMaximum(Number value) {
        this.maximum = value;
        return this;
    }

    public SchemaInfo maximum(Object value) {
        return this.setMaximum(ConverterUtils.toNumber(value));
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public SchemaInfo setExclusiveMaximum(Boolean value) {
        this.exclusiveMaximum = value;
        return this;
    }

    public SchemaInfo exclusiveMaximum(Object value) {
        return this.setExclusiveMaximum(ConverterUtils.toBoolean(value));
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public SchemaInfo setMinimum(Number value) {
        this.minimum = value;
        return this;
    }

    public SchemaInfo minimum(Object value) {
        return this.setMinimum(ConverterUtils.toNumber(value));
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public SchemaInfo setExclusiveMinimum(Boolean value) {
        this.exclusiveMinimum = value;
        return this;
    }

    public SchemaInfo exclusiveMinimum(Object value) {
        return this.setExclusiveMinimum(ConverterUtils.toBoolean(value));
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public SchemaInfo setMaxLength(Integer value) {
        this.maxLength = value;
        return this;
    }

    public SchemaInfo maxLength(Object value) {
        return this.setMaxLength(ConverterUtils.toInteger(value));
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public SchemaInfo setMinLength(Integer value) {
        this.minLength = value;
        return this;
    }

    public SchemaInfo minLength(Object value) {
        return this.setMinLength(ConverterUtils.toInteger(value));
    }

    public String getPattern() {
        return this.pattern;
    }

    public SchemaInfo setPattern(String value) {
        this.pattern = value;
        return this;
    }

    public SchemaInfo pattern(Object value) {
        return this.setPattern(StringUtils.stringify(value));
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public SchemaInfo setMaxItems(Integer value) {
        this.maxItems = value;
        return this;
    }

    public SchemaInfo maxItems(Object value) {
        return this.setMaxItems(ConverterUtils.toInteger(value));
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public SchemaInfo setMinItems(Integer value) {
        this.minItems = value;
        return this;
    }

    public SchemaInfo minItems(Object value) {
        return this.setMinItems(ConverterUtils.toInteger(value));
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public SchemaInfo setUniqueItems(Boolean value) {
        this.uniqueItems = value;
        return this;
    }

    public SchemaInfo uniqueItems(Object value) {
        return this.setUniqueItems(ConverterUtils.toBoolean(value));
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public SchemaInfo setMaxProperties(Integer value) {
        this.maxProperties = value;
        return this;
    }

    public SchemaInfo maxProperties(Object value) {
        return this.setMaxProperties(ConverterUtils.toInteger(value));
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public SchemaInfo setMinProperties(Integer value) {
        this.minProperties = value;
        return this;
    }

    public SchemaInfo minProperties(Object value) {
        return this.setMinProperties(ConverterUtils.toInteger(value));
    }

    public List<String> getRequired() {
        return this.required;
    }

    public SchemaInfo setRequired(Collection<String> value) {
        this.required = CollectionUtils.newList(value);
        return this;
    }

    public SchemaInfo addRequired(Collection<String> value) {
        this.required = CollectionUtils.addToList(this.required, value);
        return this;
    }

    public SchemaInfo required(Object ... values) {
        this.required = CollectionUtils.addToList(this.required, values, String.class, new Type[0]);
        return this;
    }

    public List<Object> getEnum() {
        return this._enum;
    }

    public SchemaInfo setEnum(Collection<Object> value) {
        this._enum = CollectionUtils.newList(value);
        return this;
    }

    public SchemaInfo addEnum(Collection<Object> value) {
        this._enum = CollectionUtils.addToList(this._enum, value);
        return this;
    }

    public SchemaInfo _enum(Object ... values) {
        this._enum = CollectionUtils.addToList(this._enum, values, Object.class, new Type[0]);
        return this;
    }

    public String getType() {
        return this.type;
    }

    public SchemaInfo setType(String value) {
        this.type = value;
        return this;
    }

    public SchemaInfo type(Object value) {
        return this.setType(StringUtils.stringify(value));
    }

    public Items getItems() {
        return this.items;
    }

    public SchemaInfo setItems(Items value) {
        this.items = value;
        return this;
    }

    public SchemaInfo items(Object value) {
        return this.setItems(ConverterUtils.toType(value, Items.class));
    }

    public List<Object> getAllOf() {
        return this.allOf;
    }

    public SchemaInfo setAllOf(Collection<Object> value) {
        this.allOf = CollectionUtils.newList(value);
        return this;
    }

    public SchemaInfo addAllOf(Collection<Object> values) {
        this.allOf = CollectionUtils.addToList(this.allOf, values);
        return this;
    }

    public SchemaInfo allOf(Object ... values) {
        this.allOf = CollectionUtils.addToList(this.allOf, values, Object.class, new Type[0]);
        return this;
    }

    public Map<String, SchemaInfo> getProperties() {
        return this.properties;
    }

    public SchemaInfo setProperties(Map<String, SchemaInfo> value) {
        this.properties = CollectionUtils.newMap(value);
        return this;
    }

    public SchemaInfo addProperties(Map<String, SchemaInfo> values) {
        this.properties = CollectionUtils.addToMap(this.properties, values);
        return this;
    }

    public SchemaInfo properties(Object ... values) {
        this.properties = CollectionUtils.addToMap(this.properties, values, String.class, SchemaInfo.class, new Type[0]);
        return this;
    }

    public SchemaInfo getAdditionalProperties() {
        return this.additionalProperties;
    }

    public SchemaInfo setAdditionalProperties(SchemaInfo value) {
        this.additionalProperties = value;
        return this;
    }

    public SchemaInfo additionalProperties(Object value) {
        this.additionalProperties = ConverterUtils.toType(value, SchemaInfo.class);
        return this;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public SchemaInfo setDiscriminator(String value) {
        this.discriminator = value;
        return this;
    }

    public SchemaInfo discriminator(Object value) {
        return this.setDiscriminator(StringUtils.stringify(value));
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public SchemaInfo setReadOnly(Boolean value) {
        this.readOnly = value;
        return this;
    }

    public SchemaInfo readOnly(Object value) {
        return this.setReadOnly(ConverterUtils.toBoolean(value));
    }

    public Xml getXml() {
        return this.xml;
    }

    public SchemaInfo setXml(Xml value) {
        this.xml = value;
        return this;
    }

    public SchemaInfo xml(Object value) {
        return this.setXml(ConverterUtils.toType(value, Xml.class));
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public SchemaInfo setExternalDocs(ExternalDocumentation value) {
        this.externalDocs = value;
        return this;
    }

    public SchemaInfo externalDocs(Object value) {
        return this.setExternalDocs(ConverterUtils.toType(value, ExternalDocumentation.class));
    }

    public Object getExample() {
        return this.example;
    }

    public SchemaInfo setExample(Object value) {
        this.example = value;
        return this;
    }

    public SchemaInfo example(Object value) {
        return this.setExample(value);
    }

    @Beanp(value="$ref")
    public String getRef() {
        return this.ref;
    }

    public boolean hasRef() {
        return this.ref != null;
    }

    @Beanp(value="$ref")
    public SchemaInfo setRef(Object value) {
        this.ref = StringUtils.stringify(value);
        return this;
    }

    public SchemaInfo ref(Object value) {
        return this.setRef(value);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "format": {
                return ConverterUtils.toType(this.getFormat(), type);
            }
            case "title": {
                return ConverterUtils.toType(this.getTitle(), type);
            }
            case "description": {
                return ConverterUtils.toType(this.getDescription(), type);
            }
            case "default": {
                return ConverterUtils.toType(this.getDefault(), type);
            }
            case "multipleOf": {
                return ConverterUtils.toType(this.getMultipleOf(), type);
            }
            case "maximum": {
                return ConverterUtils.toType(this.getMaximum(), type);
            }
            case "exclusiveMaximum": {
                return ConverterUtils.toType(this.getExclusiveMaximum(), type);
            }
            case "minimum": {
                return ConverterUtils.toType(this.getMinimum(), type);
            }
            case "exclusiveMinimum": {
                return ConverterUtils.toType(this.getExclusiveMinimum(), type);
            }
            case "maxLength": {
                return ConverterUtils.toType(this.getMaxLength(), type);
            }
            case "minLength": {
                return ConverterUtils.toType(this.getMinLength(), type);
            }
            case "pattern": {
                return ConverterUtils.toType(this.getPattern(), type);
            }
            case "maxItems": {
                return ConverterUtils.toType(this.getMaxItems(), type);
            }
            case "minItems": {
                return ConverterUtils.toType(this.getMinItems(), type);
            }
            case "uniqueItems": {
                return ConverterUtils.toType(this.getUniqueItems(), type);
            }
            case "maxProperties": {
                return ConverterUtils.toType(this.getMaxProperties(), type);
            }
            case "minProperties": {
                return ConverterUtils.toType(this.getMinProperties(), type);
            }
            case "required": {
                return ConverterUtils.toType(this.getRequired(), type);
            }
            case "enum": {
                return ConverterUtils.toType(this.getEnum(), type);
            }
            case "type": {
                return ConverterUtils.toType(this.getType(), type);
            }
            case "items": {
                return ConverterUtils.toType(this.getItems(), type);
            }
            case "allOf": {
                return ConverterUtils.toType(this.getAllOf(), type);
            }
            case "properties": {
                return ConverterUtils.toType(this.getProperties(), type);
            }
            case "additionalProperties": {
                return ConverterUtils.toType(this.getAdditionalProperties(), type);
            }
            case "discriminator": {
                return ConverterUtils.toType(this.getDiscriminator(), type);
            }
            case "readOnly": {
                return ConverterUtils.toType(this.getReadOnly(), type);
            }
            case "xml": {
                return ConverterUtils.toType(this.getXml(), type);
            }
            case "externalDocs": {
                return ConverterUtils.toType(this.getExternalDocs(), type);
            }
            case "example": {
                return ConverterUtils.toType(this.getExample(), type);
            }
            case "$ref": {
                return ConverterUtils.toType(this.getRef(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public SchemaInfo set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "format": {
                return this.format(value);
            }
            case "title": {
                return this.title(value);
            }
            case "description": {
                return this.description(value);
            }
            case "default": {
                return this._default(value);
            }
            case "multipleOf": {
                return this.multipleOf(value);
            }
            case "maximum": {
                return this.maximum(value);
            }
            case "exclusiveMaximum": {
                return this.exclusiveMaximum(value);
            }
            case "minimum": {
                return this.minimum(value);
            }
            case "exclusiveMinimum": {
                return this.exclusiveMinimum(value);
            }
            case "maxLength": {
                return this.maxLength(value);
            }
            case "minLength": {
                return this.minLength(value);
            }
            case "pattern": {
                return this.pattern(value);
            }
            case "maxItems": {
                return this.maxItems(value);
            }
            case "minItems": {
                return this.minItems(value);
            }
            case "uniqueItems": {
                return this.uniqueItems(value);
            }
            case "maxProperties": {
                return this.maxProperties(value);
            }
            case "minProperties": {
                return this.minProperties(value);
            }
            case "required": {
                return this.setRequired(null).required(value);
            }
            case "enum": {
                return this.setEnum(null)._enum(value);
            }
            case "type": {
                return this.type(value);
            }
            case "items": {
                return this.items(value);
            }
            case "allOf": {
                return this.setAllOf(null).allOf(value);
            }
            case "properties": {
                return this.setProperties(null).properties(value);
            }
            case "additionalProperties": {
                return this.additionalProperties(value);
            }
            case "discriminator": {
                return this.discriminator(value);
            }
            case "readOnly": {
                return this.readOnly(value);
            }
            case "xml": {
                return this.xml(value);
            }
            case "externalDocs": {
                return this.externalDocs(value);
            }
            case "example": {
                return this.example(value);
            }
            case "$ref": {
                return this.ref(value);
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        ASet<String> s = ASet.of(new String[0]).aif(this.format != null, "format").aif(this.title != null, "title").aif(this.description != null, "description").aif(this._default != null, "default").aif(this.multipleOf != null, "multipleOf").aif(this.maximum != null, "maximum").aif(this.exclusiveMaximum != null, "exclusiveMaximum").aif(this.minimum != null, "minimum").aif(this.exclusiveMinimum != null, "exclusiveMinimum").aif(this.maxLength != null, "maxLength").aif(this.minLength != null, "minLength").aif(this.pattern != null, "pattern").aif(this.maxItems != null, "maxItems").aif(this.minItems != null, "minItems").aif(this.uniqueItems != null, "uniqueItems").aif(this.maxProperties != null, "maxProperties").aif(this.minProperties != null, "minProperties").aif(this.required != null, "required").aif(this._enum != null, "enum").aif(this.type != null, "type").aif(this.items != null, "items").aif(this.allOf != null, "allOf").aif(this.properties != null, "properties").aif(this.additionalProperties != null, "additionalProperties").aif(this.discriminator != null, "discriminator").aif(this.readOnly != null, "readOnly").aif(this.xml != null, "xml").aif(this.externalDocs != null, "externalDocs").aif(this.example != null, "example").aif(this.ref != null, "$ref");
        return new MultiSet<String>(s, super.keySet());
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public SchemaInfo resolveRefs(Swagger swagger, Deque<String> refStack, int maxDepth) {
        if (this.ref != null) {
            if (refStack.contains(this.ref) || refStack.size() >= maxDepth) {
                return this;
            }
            refStack.addLast(this.ref);
            SchemaInfo r = swagger.findRef(this.ref, SchemaInfo.class).resolveRefs(swagger, refStack, maxDepth);
            refStack.removeLast();
            return r;
        }
        if (this.items != null) {
            this.items = this.items.resolveRefs(swagger, refStack, maxDepth);
        }
        if (this.properties != null) {
            for (Map.Entry<String, SchemaInfo> e : this.properties.entrySet()) {
                e.setValue(e.getValue().resolveRefs(swagger, refStack, maxDepth));
            }
        }
        if (this.additionalProperties != null) {
            this.additionalProperties = this.additionalProperties.resolveRefs(swagger, refStack, maxDepth);
        }
        this.example = null;
        return this;
    }
}

