/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.vars;

import java.util.List;
import org.apache.juneau.dto.swagger.Contact;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.License;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.http.exception.HttpException;
import org.apache.juneau.http.exception.InternalServerError;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.rest.HttpRuntimeException;
import org.apache.juneau.rest.RestInfoProvider;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.svl.MultipartResolvingVar;
import org.apache.juneau.svl.VarResolverSession;

public class RestInfoVar
extends MultipartResolvingVar {
    private static final String SESSION_req = "req";
    public static final String NAME = "RI";

    public RestInfoVar() {
        super(NAME);
    }

    protected boolean allowNested() {
        return false;
    }

    protected boolean allowRecurse() {
        return false;
    }

    public String resolve(VarResolverSession session, String key) throws HttpException, InternalServerError {
        try {
            RestRequest req = (RestRequest)((Object)session.getSessionObject(RestRequest.class, SESSION_req, true));
            Swagger swagger = req.getSwagger();
            RestInfoProvider rip = req.getInfoProvider();
            SimpleJsonSerializer s = SimpleJsonSerializer.DEFAULT;
            char c = StringUtils.charAt((String)key, (int)0);
            if (c == 'c') {
                if ("contact".equals(key)) {
                    Contact x = swagger.getInfo().getContact();
                    return x == null ? null : s.toString((Object)x);
                }
            } else if (c == 'd') {
                if ("description".equals(key)) {
                    return rip.getDescription(req);
                }
            } else if (c == 'e') {
                if ("externalDocs".equals(key)) {
                    ExternalDocumentation x = swagger.getExternalDocs();
                    return x == null ? null : s.toString((Object)x);
                }
            } else if (c == 'l') {
                if ("license".equals(key)) {
                    License x = swagger.getInfo().getLicense();
                    return x == null ? null : s.toString((Object)x);
                }
            } else if (c == 'm') {
                if ("methodDescription".equals(key)) {
                    return rip.getMethodDescription(req.getJavaMethod(), req);
                }
                if ("methodSummary".equals(key)) {
                    return rip.getMethodSummary(req.getJavaMethod(), req);
                }
            } else if (c == 's') {
                if ("siteName".equals(key)) {
                    return rip.getSiteName(req);
                }
            } else if (c == 't') {
                if ("tags".equals(key)) {
                    List x = swagger.getTags();
                    return x == null ? null : s.toString((Object)x);
                }
                if ("termsOfService".equals(key)) {
                    return swagger.getInfo().getTermsOfService();
                }
                if ("title".equals(key)) {
                    return swagger.getInfo().getTitle();
                }
            } else if (c == 'v' && "version".equals(key)) {
                return swagger.getInfo().getVersion();
            }
            return null;
        }
        catch (Exception e) {
            throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
        }
    }

    public boolean canResolve(VarResolverSession session) {
        return session.hasSessionObject(SESSION_req);
    }
}

