/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.common.internal.IOUtils;

public class LocalFile {
    private final Class<?> clazz;
    private final String clazzPath;
    private final Path path;
    private final String name;
    private byte[] cache;

    public LocalFile(Class<?> clazz, String clazzPath) {
        this.clazz = (Class)ArgUtils.assertArgNotNull((String)"clazz", clazz);
        this.clazzPath = (String)ArgUtils.assertArgNotNull((String)"clazzPath", (Object)clazzPath);
        this.path = null;
        int i = clazzPath.lastIndexOf(47);
        this.name = i == -1 ? clazzPath : clazzPath.substring(i + 1);
    }

    public LocalFile(Path path) {
        this.clazz = null;
        this.clazzPath = null;
        this.path = (Path)ArgUtils.assertArgNotNull((String)"path", (Object)path);
        this.name = path.getFileName().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream read() throws IOException {
        LocalFile localFile = this;
        synchronized (localFile) {
            if (this.cache != null) {
                return new ByteArrayInputStream(this.cache);
            }
        }
        if (this.clazz != null) {
            return this.clazz.getResourceAsStream(this.clazzPath);
        }
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    public long size() throws IOException {
        return this.path == null ? -1L : Files.size(this.path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalFile cache() throws IOException {
        LocalFile localFile = this;
        synchronized (localFile) {
            this.cache = IOUtils.readBytes((InputStream)this.read());
        }
        return this;
    }

    public String getName() {
        return this.name;
    }
}

