/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.mod;

import java.util.function.Function;

public class Mod {
    public static final Mod NO_OP = new Mod(' ', x -> x, x -> x, x -> true);
    private final char id;
    private final Function<String, String> removeFunction;
    private final Function<String, String> applyFunction;
    private final Function<String, Boolean> detectFunction;

    public Mod(char id, Function<String, String> applyFunction, Function<String, String> removeFunction, Function<String, Boolean> detectFunction) {
        this.id = id;
        this.applyFunction = applyFunction;
        this.removeFunction = removeFunction;
        this.detectFunction = detectFunction;
    }

    public char getId() {
        return this.id;
    }

    public boolean isApplied(String value) {
        return this.detectFunction.apply(value);
    }

    public String apply(String value) {
        return this.applyFunction.apply(value);
    }

    public String remove(String value) {
        return this.removeFunction.apply(value);
    }

    public final String doApply(String value) {
        return this.isApplied(value) ? value : this.apply(value);
    }

    public final String doRemove(String value) {
        return this.isApplied(value) ? this.remove(value) : value;
    }
}

