/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command;

import java.util.Dictionary;
import org.apache.karaf.config.command.ConfigPropertyCommandSupport;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;

@Command(scope="config", name="property-append", description="Appends the given value to an existing property or creates the property with the specified name and value.")
public class PropAppendCommand
extends ConfigPropertyCommandSupport {
    @Argument(index=0, name="name", description="The name of the property", required=true, multiValued=false)
    String prop;
    @Argument(index=1, name="value", description="The value to append to the property", required=true, multiValued=false)
    String value;

    @Override
    public void propertyAction(Dictionary props) {
        Object currentValue = props.get(this.prop);
        if (currentValue == null) {
            props.put(this.prop, this.value);
        } else if (currentValue instanceof String) {
            props.put(this.prop, currentValue + this.value);
        } else {
            System.err.println("Append Failed: current value is not a String.");
        }
    }
}

