/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command.wikidoc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;
import org.apache.karaf.bundle.command.wikidoc.WikiVisitor;
import org.apache.karaf.util.StringEscapeUtils;

public class WikiParser {
    WikiVisitor visitor;

    public WikiParser(WikiVisitor visitor) {
        this.visitor = visitor;
    }

    public void parse(String line) {
        String unescaped = StringEscapeUtils.unescapeJava(line);
        StringTokenizer tokenizer = new StringTokenizer(unescaped, "\u001b[h*", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if ("\u001b".equals(token)) {
                this.parseEsc(tokenizer, token);
                continue;
            }
            if ("[".equals(token)) {
                this.parseLink(tokenizer);
                continue;
            }
            if ("h".equals(token)) {
                this.parseHeading(tokenizer);
                continue;
            }
            if ("*".equals(token)) {
                this.parseEnumeration(tokenizer);
                continue;
            }
            this.visitor.text(token);
        }
    }

    private void parseEsc(StringTokenizer tokenizer, String token) {
        this.visitor.text(token + tokenizer.nextToken() + tokenizer.nextToken("\u001b[]"));
    }

    private void parseEnumeration(StringTokenizer tokenizer) {
        String text = tokenizer.nextToken("-\n");
        this.visitor.enumeration(text.trim());
    }

    private void parseHeading(StringTokenizer tokenizer) {
        String level = tokenizer.nextToken("123456789");
        if (!level.matches("[123456789]")) {
            this.visitor.text("h" + level);
            return;
        }
        String dot = tokenizer.nextToken(".\n");
        if (!".".equals(dot)) {
            this.visitor.text("h" + level + dot);
            return;
        }
        String heading = tokenizer.hasMoreTokens() ? tokenizer.nextToken("\n") : "";
        this.visitor.heading(new Integer(level), heading.trim());
    }

    private void parseLink(StringTokenizer tokenizer) {
        String token = tokenizer.nextToken("]");
        this.visitor.link(token, "");
        tokenizer.nextToken();
    }

    public void parse(Reader reader) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(reader);
        while ((line = br.readLine()) != null) {
            this.parse(line);
            this.visitor.text("\n");
        }
    }
}

