/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.filter;

import org.apache.log4j.filter.MatchFilterBase;
import org.apache.log4j.spi.LoggingEvent;

public class MDCMatchFilter
extends MatchFilterBase {
    String keyToMatch;
    String valueToMatch;
    boolean exactMatch = false;

    public void setKeyToMatch(String key) {
        this.keyToMatch = key;
    }

    public String getKeyToMatch() {
        return this.keyToMatch;
    }

    public void setValueToMatch(String value) {
        this.valueToMatch = value;
    }

    public String getValueToMatch() {
        return this.valueToMatch;
    }

    public void setExactMatch(boolean exact) {
        this.exactMatch = exact;
    }

    public boolean getExactMatch() {
        return this.exactMatch;
    }

    @Override
    protected boolean canMatch() {
        return this.keyToMatch != null;
    }

    @Override
    protected boolean match(LoggingEvent event) {
        Object mdcObject = event.getMDC(this.keyToMatch);
        String mdcValue = mdcObject != null ? mdcObject.toString() : null;
        if (mdcValue == null) {
            return this.valueToMatch == null;
        }
        if (this.valueToMatch != null) {
            if (this.exactMatch) {
                return mdcValue.equals(this.valueToMatch);
            }
            return mdcValue.indexOf(this.valueToMatch) != -1;
        }
        return false;
    }
}

