/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.karaf.features.FeatureEvent;
import org.apache.karaf.features.FeaturesListener;
import org.apache.karaf.features.RepositoryEvent;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class EventAdminListener
implements FeaturesListener {
    private final ServiceTracker<EventAdmin, EventAdmin> tracker;

    public EventAdminListener(BundleContext context) {
        this.tracker = new ServiceTracker(context, EventAdmin.class.getName(), null);
        this.tracker.open();
    }

    @Override
    public void featureEvent(FeatureEvent event) {
        String topic;
        EventAdmin eventAdmin = (EventAdmin)this.tracker.getService();
        if (eventAdmin == null) {
            return;
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("type", (Object)((Object)event.getType()));
        ((Dictionary)props).put("event", event);
        ((Dictionary)props).put("timestamp", System.currentTimeMillis());
        ((Dictionary)props).put("name", event.getFeature().getName());
        ((Dictionary)props).put("version", event.getFeature().getVersion());
        switch (event.getType()) {
            case FeatureInstalled: {
                topic = "org/apache/karaf/features/features/INSTALLED";
                break;
            }
            case FeatureUninstalled: {
                topic = "org/apache/karaf/features/features/UNINSTALLED";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown features event type: " + (Object)((Object)event.getType()));
            }
        }
        eventAdmin.postEvent(new Event(topic, props));
    }

    @Override
    public void repositoryEvent(RepositoryEvent event) {
        String topic;
        EventAdmin eventAdmin = (EventAdmin)this.tracker.getService();
        if (eventAdmin == null) {
            return;
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("type", (Object)((Object)event.getType()));
        ((Dictionary)props).put("event", event);
        ((Dictionary)props).put("timestamp", System.currentTimeMillis());
        ((Dictionary)props).put("name", event.getRepository().getName());
        ((Dictionary)props).put("uri", event.getRepository().getURI().toString());
        switch (event.getType()) {
            case RepositoryAdded: {
                topic = "org/apache/karaf/features/repositories/ADDED";
                break;
            }
            case RepositoryRemoved: {
                topic = "org/apache/karaf/features/repositories/REMOVED";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown repository event type: " + (Object)((Object)event.getType()));
            }
        }
        eventAdmin.postEvent(new Event(topic, props));
    }
}

