/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.management.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeatureEvent;
import org.apache.karaf.features.FeaturesListener;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.RepositoryEvent;
import org.apache.karaf.features.management.FeaturesServiceMBean;
import org.apache.karaf.features.management.codec.JmxFeature;
import org.apache.karaf.features.management.codec.JmxFeatureEvent;
import org.apache.karaf.features.management.codec.JmxRepository;
import org.apache.karaf.features.management.codec.JmxRepositoryEvent;
import org.apache.karaf.features.management.internal.StandardEmitterMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class FeaturesServiceMBeanImpl
extends StandardEmitterMBean
implements MBeanRegistration,
FeaturesServiceMBean {
    private ServiceRegistration<FeaturesListener> registration;
    private BundleContext bundleContext;
    private ObjectName objectName;
    private volatile long sequenceNumber = 0L;
    private FeaturesService featuresService;

    public FeaturesServiceMBeanImpl() throws NotCompliantMBeanException {
        super((Class)FeaturesServiceMBean.class);
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.objectName = name;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        this.registration = this.bundleContext.registerService(FeaturesListener.class, (Object)this.getFeaturesListener(), new Hashtable());
    }

    @Override
    public void preDeregister() throws Exception {
        this.registration.unregister();
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public TabularData getFeatures() throws Exception {
        try {
            List<Feature> allFeatures = Arrays.asList(this.featuresService.listFeatures());
            List<Feature> insFeatures = Arrays.asList(this.featuresService.listInstalledFeatures());
            ArrayList<JmxFeature> features = new ArrayList<JmxFeature>();
            for (Feature feature : allFeatures) {
                try {
                    features.add(new JmxFeature(feature, insFeatures.contains(feature)));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            TabularData table = JmxFeature.tableFrom(features);
            return table;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    @Override
    public TabularData getRepositories() throws Exception {
        try {
            List<Repository> allRepositories = Arrays.asList(this.featuresService.listRepositories());
            ArrayList<JmxRepository> repositories = new ArrayList<JmxRepository>();
            for (Repository repository : allRepositories) {
                try {
                    repositories.add(new JmxRepository(repository));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            TabularData table = JmxRepository.tableFrom(repositories);
            return table;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    @Override
    public void addRepository(String uri) throws Exception {
        this.featuresService.addRepository(new URI(uri));
    }

    @Override
    public void addRepository(String uri, boolean install) throws Exception {
        this.featuresService.addRepository(new URI(uri), install);
    }

    @Override
    public void removeRepository(String uri) throws Exception {
        this.featuresService.removeRepository(new URI(uri));
    }

    @Override
    public void removeRepository(String uri, boolean uninstall) throws Exception {
        this.featuresService.removeRepository(new URI(uri), uninstall);
    }

    @Override
    public void refreshRepository(String url) throws Exception {
        ArrayList<URI> uris = new ArrayList<URI>();
        if (url != null && !url.isEmpty()) {
            Pattern pattern = Pattern.compile(url);
            for (Repository r : this.featuresService.listRepositories()) {
                Matcher matcher = pattern.matcher(r.getURI().toString());
                if (!matcher.matches()) continue;
                uris.add(r.getURI());
            }
        } else {
            for (Repository r : this.featuresService.listRepositories()) {
                uris.add(r.getURI());
            }
        }
        for (URI u : uris) {
            this.featuresService.refreshRepository(u);
        }
    }

    @Override
    public void installFeature(String name) throws Exception {
        this.featuresService.installFeature(name);
    }

    @Override
    public void installFeature(String name, boolean noClean, boolean noRefresh) throws Exception {
        EnumSet<FeaturesService.Option> options = EnumSet.noneOf(FeaturesService.Option.class);
        if (noClean) {
            options.add(FeaturesService.Option.NoCleanIfFailure);
        }
        if (noRefresh) {
            options.add(FeaturesService.Option.NoAutoRefreshBundles);
        }
        this.featuresService.installFeature(name, options);
    }

    @Override
    public void installFeature(String name, boolean noClean, boolean noRefresh, boolean noStart) throws Exception {
        EnumSet<FeaturesService.Option> options = EnumSet.noneOf(FeaturesService.Option.class);
        if (noClean) {
            options.add(FeaturesService.Option.NoCleanIfFailure);
        }
        if (noRefresh) {
            options.add(FeaturesService.Option.NoAutoRefreshBundles);
        }
        if (noStart) {
            options.add(FeaturesService.Option.NoAutoStartBundles);
        }
        this.featuresService.installFeature(name, options);
    }

    @Override
    public void installFeature(String name, String version) throws Exception {
        this.featuresService.installFeature(name, version);
    }

    @Override
    public void installFeature(String name, String version, boolean noClean, boolean noRefresh) throws Exception {
        EnumSet<FeaturesService.Option> options = EnumSet.noneOf(FeaturesService.Option.class);
        if (noClean) {
            options.add(FeaturesService.Option.NoCleanIfFailure);
        }
        if (noRefresh) {
            options.add(FeaturesService.Option.NoAutoRefreshBundles);
        }
        this.featuresService.installFeature(name, version, options);
    }

    @Override
    public void installFeature(String name, String version, boolean noClean, boolean noRefresh, boolean noStart) throws Exception {
        EnumSet<FeaturesService.Option> options = EnumSet.noneOf(FeaturesService.Option.class);
        if (noClean) {
            options.add(FeaturesService.Option.NoCleanIfFailure);
        }
        if (noRefresh) {
            options.add(FeaturesService.Option.NoAutoRefreshBundles);
        }
        if (noStart) {
            options.add(FeaturesService.Option.NoAutoStartBundles);
        }
        this.featuresService.installFeature(name, version, options);
    }

    @Override
    public TabularData infoFeature(String name) throws Exception {
        try {
            Feature feature = this.featuresService.getFeature(name);
            return this.infoFeature(feature);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    @Override
    public TabularData infoFeature(String name, String version) throws Exception {
        try {
            Feature feature = this.featuresService.getFeature(name, version);
            return this.infoFeature(feature);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private TabularData infoFeature(Feature feature) throws Exception {
        JmxFeature jmxFeature = null;
        jmxFeature = this.featuresService.isInstalled(feature) ? new JmxFeature(feature, true) : new JmxFeature(feature, false);
        ArrayList<JmxFeature> features = new ArrayList<JmxFeature>();
        features.add(jmxFeature);
        TabularData table = JmxFeature.tableFrom(features);
        return table;
    }

    @Override
    public void uninstallFeature(String name) throws Exception {
        this.featuresService.uninstallFeature(name);
    }

    @Override
    public void uninstallFeature(String name, boolean noRefresh) throws Exception {
        EnumSet<FeaturesService.Option> options = EnumSet.noneOf(FeaturesService.Option.class);
        if (noRefresh) {
            options.add(FeaturesService.Option.NoAutoRefreshBundles);
        }
        this.featuresService.uninstallFeature(name, options);
    }

    @Override
    public void uninstallFeature(String name, boolean noRefresh, boolean recursive) throws Exception {
        EnumSet<FeaturesService.Option> options = EnumSet.noneOf(FeaturesService.Option.class);
        if (noRefresh) {
            options.add(FeaturesService.Option.NoAutoRefreshBundles);
        }
        if (recursive) {
            options.add(FeaturesService.Option.Recursive);
        }
        this.featuresService.uninstallFeature(name, options);
    }

    @Override
    public void uninstallFeature(String name, String version) throws Exception {
        this.featuresService.uninstallFeature(name, version);
    }

    @Override
    public void uninstallFeature(String name, String version, boolean noRefresh) throws Exception {
        EnumSet<FeaturesService.Option> options = EnumSet.noneOf(FeaturesService.Option.class);
        if (noRefresh) {
            options.add(FeaturesService.Option.NoAutoRefreshBundles);
        }
        this.featuresService.uninstallFeature(name, version, options);
    }

    @Override
    public void uninstallFeature(String name, String version, boolean noRefresh, boolean recursive) throws Exception {
        EnumSet<FeaturesService.Option> options = EnumSet.noneOf(FeaturesService.Option.class);
        if (noRefresh) {
            options.add(FeaturesService.Option.NoAutoRefreshBundles);
        }
        if (recursive) {
            options.add(FeaturesService.Option.Recursive);
        }
        this.featuresService.uninstallFeature(name, version, options);
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    public FeaturesListener getFeaturesListener() {
        return new FeaturesListener(){

            @Override
            public void featureEvent(FeatureEvent event) {
                if (!event.isReplay()) {
                    Notification notification = new Notification("org.apache.karaf.features.featureEvent", FeaturesServiceMBeanImpl.this.objectName, FeaturesServiceMBeanImpl.this.sequenceNumber++);
                    notification.setUserData(new JmxFeatureEvent(event).asCompositeData());
                    FeaturesServiceMBeanImpl.this.sendNotification(notification);
                }
            }

            @Override
            public void repositoryEvent(RepositoryEvent event) {
                if (!event.isReplay()) {
                    Notification notification = new Notification("org.apache.karaf.features.repositoryEvent", FeaturesServiceMBeanImpl.this.objectName, FeaturesServiceMBeanImpl.this.sequenceNumber++);
                    notification.setUserData(new JmxRepositoryEvent(event).asCompositeData());
                    FeaturesServiceMBeanImpl.this.sendNotification(notification);
                }
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                return o.equals(this);
            }
        };
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return FeaturesServiceMBeanImpl.getBroadcastInfo();
    }

    private static MBeanNotificationInfo[] getBroadcastInfo() {
        String type = Notification.class.getCanonicalName();
        MBeanNotificationInfo info1 = new MBeanNotificationInfo(new String[]{"Type"}, type, "Some features notification");
        MBeanNotificationInfo info2 = new MBeanNotificationInfo(new String[]{"Type"}, type, "Some repository notification");
        return new MBeanNotificationInfo[]{info1, info2};
    }
}

