/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import java.util.regex.Pattern;
import jline.Terminal;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;
import org.apache.karaf.util.StreamUtils;
import org.jledit.ConsoleEditor;
import org.jledit.EditorFactory;

@Command(scope="shell", name="edit", description="Calls a text editor.")
public class EditAction
extends AbstractAction {
    private final Pattern URL_PATTERN = Pattern.compile("[^: ]+:[^ ]+");
    @Argument(index=0, name="url", description="The url of the resource to edit.", required=true, multiValued=false)
    private String url;
    private EditorFactory editorFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        File file;
        boolean isLocal;
        String path;
        OutputStream os;
        InputStream is;
        block16: {
            URL u;
            block18: {
                URLConnection connection = null;
                is = null;
                os = null;
                path = null;
                isLocal = true;
                String sourceUrl = this.url;
                if (!this.URL_PATTERN.matcher(sourceUrl).matches()) {
                    File f = new File(sourceUrl);
                    sourceUrl = "file://" + f.getAbsolutePath();
                }
                if ((u = new URL(sourceUrl)).getProtocol().equals("file")) break block18;
                isLocal = false;
                try {
                    connection = u.openConnection();
                    is = connection.getInputStream();
                }
                catch (IOException ex) {
                    System.out.println("Failed to open " + sourceUrl + " for reading.");
                    return null;
                }
                try {
                    os = connection.getOutputStream();
                }
                catch (IOException ex) {
                    System.out.println("Failed to open " + sourceUrl + " for writing.");
                    return null;
                }
                FileOutputStream fos = null;
                try {
                    path = System.getProperty("karaf.data") + "/editor/" + UUID.randomUUID();
                    File f = new File(path);
                    if (!f.exists() && !f.getParentFile().exists()) {
                        f.getParentFile().mkdirs();
                    }
                    fos = new FileOutputStream(f);
                    this.copy(is, fos);
                }
                catch (Exception ex) {
                    try {
                        System.out.println("Failed to copy resource from url:" + sourceUrl + " to tmp file: " + path + "  for editing.");
                    }
                    catch (Throwable throwable) {
                        StreamUtils.close(fos);
                        throw throwable;
                    }
                    StreamUtils.close(fos);
                    break block16;
                }
                StreamUtils.close(fos);
                break block16;
            }
            path = u.getFile();
        }
        if (!(file = new File(path)).exists() && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        ConsoleEditor editor = this.editorFactory.create(this.getTerminal());
        editor.setTitle("Karaf");
        editor.open(file.getAbsolutePath(), this.url);
        editor.setOpenEnabled(false);
        editor.start();
        if (!isLocal) {
            FileInputStream fis = new FileInputStream(path);
            try {
                this.copy(fis, os);
            }
            catch (Throwable throwable) {
                StreamUtils.close(fis);
                throw throwable;
            }
            StreamUtils.close(fis);
        }
        if (is != null) {
            StreamUtils.close(is);
        }
        if (os != null) {
            StreamUtils.close(os);
        }
        return null;
    }

    private Terminal getTerminal() throws Exception {
        Object terminalObject = this.session.get(".jline.terminal");
        if (terminalObject instanceof Terminal) {
            return (Terminal)terminalObject;
        }
        throw new IllegalStateException("Could not get Terminal from CommandSession.");
    }

    private void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[16384];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            output.flush();
        }
    }

    public EditorFactory getEditorFactory() {
        return this.editorFactory;
    }

    public void setEditorFactory(EditorFactory editorFactory) {
        this.editorFactory = editorFactory;
    }
}

