/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.completer;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.CommandSessionHolder;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

public class CommandNamesCompleter
implements Completer {
    public static final String COMMANDS = ".commands";
    private CommandSession session;
    private final Set<String> commands = new CopyOnWriteArraySet<String>();

    public CommandNamesCompleter() {
        this(CommandSessionHolder.getSession());
    }

    public CommandNamesCompleter(CommandSession session) {
        this.session = session;
        try {
            new CommandTracker();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public int complete(String buffer, int cursor, List<String> candidates) {
        if (this.session == null) {
            this.session = CommandSessionHolder.getSession();
        }
        this.checkData();
        int res = new StringsCompleter(this.commands).complete(buffer, cursor, (List)candidates);
        Collections.sort(candidates);
        return res;
    }

    protected void checkData() {
        if (this.commands.isEmpty()) {
            HashSet names = new HashSet((Set)this.session.get(COMMANDS));
            for (String name : names) {
                this.commands.add(name);
                if (name.indexOf(58) <= 0) continue;
                this.commands.add(name.substring(0, name.indexOf(58)));
            }
        }
    }

    private class CommandTracker {
        public CommandTracker() throws Exception {
            BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            if (context == null) {
                throw new IllegalStateException("Bundle is stopped");
            }
            ServiceListener listener = new ServiceListener(){

                public void serviceChanged(ServiceEvent event) {
                    CommandNamesCompleter.this.commands.clear();
                }
            };
            context.addServiceListener(listener, String.format("(&(%s=*)(%s=*))", "osgi.command.scope", "osgi.command.function"));
        }
    }
}

