/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.aries.blueprint.container.BeanRecipe;
import org.apache.aries.blueprint.container.GenericType;
import org.apache.aries.blueprint.di.CollectionRecipe;
import org.apache.aries.blueprint.di.MapRecipe;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.apache.aries.blueprint.utils.ReflectionUtils;
import org.osgi.service.blueprint.container.Converter;
import org.osgi.service.blueprint.container.ReifiedType;

public class AggregateConverter
implements Converter {
    private ExtendedBlueprintContainer blueprintContainer;
    private List<Converter> converters = new ArrayList<Converter>();
    private static final Map<Class, Class> primitives = new HashMap<Class, Class>();

    public AggregateConverter(ExtendedBlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public void registerConverter(Converter converter) {
        this.converters.add(converter);
    }

    public void unregisterConverter(Converter converter) {
        this.converters.remove(converter);
    }

    public boolean canConvert(Object fromValue, final ReifiedType toType) {
        if (fromValue == null) {
            return true;
        }
        if (fromValue instanceof BeanRecipe.UnwrapperedBeanHolder) {
            fromValue = ((BeanRecipe.UnwrapperedBeanHolder)fromValue).unwrapperedBean;
        }
        if (AggregateConverter.isAssignable(fromValue, toType)) {
            return true;
        }
        final Object toTest = fromValue;
        boolean canConvert = false;
        AccessControlContext acc = this.blueprintContainer.getAccessControlContext();
        canConvert = acc == null ? this.canConvertWithConverters(toTest, toType) : AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return AggregateConverter.this.canConvertWithConverters(toTest, toType);
            }
        }, acc).booleanValue();
        if (canConvert) {
            return true;
        }
        try {
            this.convert(toTest, toType);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object convert(Object fromValue, final ReifiedType type) throws Exception {
        if (fromValue == null) {
            return null;
        }
        if (fromValue instanceof Convertible) {
            return ((Convertible)fromValue).convert(type);
        }
        if (fromValue instanceof BeanRecipe.UnwrapperedBeanHolder) {
            BeanRecipe.UnwrapperedBeanHolder holder = (BeanRecipe.UnwrapperedBeanHolder)fromValue;
            if (AggregateConverter.isAssignable(holder.unwrapperedBean, type)) {
                return BeanRecipe.wrap(holder, type.getRawClass());
            }
            fromValue = BeanRecipe.wrap(holder, Object.class);
        } else if (AggregateConverter.isAssignable(fromValue, type)) {
            return fromValue;
        }
        final Object finalFromValue = fromValue;
        ConversionResult result = null;
        AccessControlContext acc = this.blueprintContainer.getAccessControlContext();
        result = acc == null ? this.convertWithConverters(fromValue, type) : AccessController.doPrivileged(new PrivilegedExceptionAction<ConversionResult>(){

            @Override
            public ConversionResult run() throws Exception {
                return AggregateConverter.this.convertWithConverters(finalFromValue, type);
            }
        }, acc);
        if (result == null) {
            if (fromValue instanceof Number && Number.class.isAssignableFrom(AggregateConverter.unwrap(this.toClass(type)))) {
                return this.convertToNumber((Number)fromValue, this.toClass(type));
            }
            if (fromValue instanceof String) {
                return this.convertFromString((String)fromValue, this.toClass(type), this.blueprintContainer);
            }
            if (this.toClass(type).isArray() && (fromValue instanceof Collection || fromValue.getClass().isArray())) {
                return this.convertToArray(fromValue, type);
            }
            if (Map.class.isAssignableFrom(this.toClass(type)) && (fromValue instanceof Map || fromValue instanceof Dictionary)) {
                return this.convertToMap(fromValue, type);
            }
            if (Dictionary.class.isAssignableFrom(this.toClass(type)) && (fromValue instanceof Map || fromValue instanceof Dictionary)) {
                return this.convertToDictionary(fromValue, type);
            }
            if (Collection.class.isAssignableFrom(this.toClass(type)) && (fromValue instanceof Collection || fromValue.getClass().isArray())) {
                return this.convertToCollection(fromValue, type);
            }
            throw new Exception("Unable to convert value " + fromValue + " to type " + type);
        }
        return result.value;
    }

    private Converter selectMatchingConverter(Object source, ReifiedType type) {
        for (Converter converter : this.converters) {
            if (!converter.canConvert(source, type)) continue;
            return converter;
        }
        return null;
    }

    private boolean canConvertWithConverters(Object source, ReifiedType type) {
        return this.selectMatchingConverter(source, type) != null;
    }

    private ConversionResult convertWithConverters(Object source, ReifiedType type) throws Exception {
        Converter converter = this.selectMatchingConverter(source, type);
        if (converter == null) {
            return null;
        }
        Object value = converter.convert(source, type);
        return new ConversionResult(converter, value);
    }

    public Object convertToNumber(Number value, Class toType) throws Exception {
        if (AtomicInteger.class == (toType = AggregateConverter.unwrap(toType))) {
            return new AtomicInteger((Integer)this.convertToNumber(value, Integer.class));
        }
        if (AtomicLong.class == toType) {
            return new AtomicLong((Long)this.convertToNumber(value, Long.class));
        }
        if (Integer.class == toType) {
            return value.intValue();
        }
        if (Short.class == toType) {
            return value.shortValue();
        }
        if (Long.class == toType) {
            return value.longValue();
        }
        if (Float.class == toType) {
            return Float.valueOf(value.floatValue());
        }
        if (Double.class == toType) {
            return value.doubleValue();
        }
        if (Byte.class == toType) {
            return value.byteValue();
        }
        if (BigInteger.class == toType) {
            return new BigInteger(value.toString());
        }
        if (BigDecimal.class == toType) {
            return new BigDecimal(value.toString());
        }
        throw new Exception("Unable to convert number " + value + " to " + toType);
    }

    public Object convertFromString(String value, Class toType, Object loader) throws Exception {
        if (ReifiedType.class == (toType = AggregateConverter.unwrap(toType))) {
            try {
                return GenericType.parse(value, loader);
            }
            catch (ClassNotFoundException e) {
                throw new Exception("Unable to convert", e);
            }
        }
        if (Class.class == toType) {
            try {
                return GenericType.parse(value, loader).getRawClass();
            }
            catch (ClassNotFoundException e) {
                throw new Exception("Unable to convert", e);
            }
        }
        if (Locale.class == toType) {
            String[] tokens = value.split("_");
            if (tokens.length == 1) {
                return new Locale(tokens[0]);
            }
            if (tokens.length == 2) {
                return new Locale(tokens[0], tokens[1]);
            }
            if (tokens.length == 3) {
                return new Locale(tokens[0], tokens[1], tokens[2]);
            }
            throw new Exception("Invalid locale string:" + value);
        }
        if (Pattern.class == toType) {
            return Pattern.compile(value);
        }
        if (Properties.class == toType) {
            Properties props = new Properties();
            ByteArrayInputStream in = new ByteArrayInputStream(value.getBytes("UTF8"));
            props.load(in);
            return props;
        }
        if (Boolean.class == toType) {
            if ("yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value)) {
                return Boolean.TRUE;
            }
            if ("no".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value) || "off".equalsIgnoreCase(value)) {
                return Boolean.FALSE;
            }
            throw new RuntimeException("Invalid boolean value: " + value);
        }
        if (Integer.class == toType) {
            return Integer.valueOf(value);
        }
        if (Short.class == toType) {
            return Short.valueOf(value);
        }
        if (Long.class == toType) {
            return Long.valueOf(value);
        }
        if (Float.class == toType) {
            return Float.valueOf(value);
        }
        if (Double.class == toType) {
            return Double.valueOf(value);
        }
        if (Character.class == toType) {
            if (value.length() == 6 && value.startsWith("\\u")) {
                int code = Integer.parseInt(value.substring(2), 16);
                return Character.valueOf((char)code);
            }
            if (value.length() == 1) {
                return Character.valueOf(value.charAt(0));
            }
            throw new Exception("Invalid value for character type: " + value);
        }
        if (Byte.class == toType) {
            return Byte.valueOf(value);
        }
        if (Enum.class.isAssignableFrom(toType)) {
            return Enum.valueOf(toType, value);
        }
        return this.createObject(value, toType);
    }

    private Object createObject(String value, Class type) throws Exception {
        if (type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
            throw new Exception("Unable to convert value " + value + " to type " + type + ". Type " + type + " is an interface or an abstract class");
        }
        Constructor constructor = null;
        try {
            constructor = type.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to convert to " + type);
        }
        try {
            return ReflectionUtils.newInstance(this.blueprintContainer.getAccessControlContext(), constructor, value);
        }
        catch (Exception e) {
            throw new Exception("Unable to convert ", ReflectionUtils.getRealCause(e));
        }
    }

    private Object convertToCollection(Object obj, ReifiedType type) throws Exception {
        ReifiedType valueType = type.getActualTypeArgument(0);
        Collection newCol = (Collection)ReflectionUtils.newInstance(this.blueprintContainer.getAccessControlContext(), CollectionRecipe.getCollection(this.toClass(type)));
        if (obj.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(obj); ++i) {
                try {
                    Object ov = Array.get(obj, i);
                    Object cv = this.convert(ov, valueType);
                    newCol.add(cv);
                    continue;
                }
                catch (Exception t) {
                    throw new Exception("Unable to convert from " + obj + " to " + type + "(error converting array element)", t);
                }
            }
            return newCol;
        }
        boolean converted = !this.toClass(type).isAssignableFrom(obj.getClass());
        for (Object item : (Collection)obj) {
            try {
                Object cv = this.convert(item, valueType);
                converted |= item != cv;
                newCol.add(cv);
            }
            catch (Exception t) {
                throw new Exception("Unable to convert from " + obj + " to " + type + "(error converting collection entry)", t);
            }
        }
        return converted ? newCol : obj;
    }

    private Object convertToDictionary(Object obj, ReifiedType type) throws Exception {
        ReifiedType keyType = type.getActualTypeArgument(0);
        ReifiedType valueType = type.getActualTypeArgument(1);
        if (obj instanceof Dictionary) {
            Hashtable<Object, Object> newDic = new Hashtable<Object, Object>();
            Dictionary dic = (Dictionary)obj;
            boolean converted = false;
            Enumeration keyEnum = dic.keys();
            while (keyEnum.hasMoreElements()) {
                Object key = keyEnum.nextElement();
                try {
                    Object nk = this.convert(key, keyType);
                    Object ov = dic.get(key);
                    Object nv = this.convert(ov, valueType);
                    ((Dictionary)newDic).put(nk, nv);
                    converted |= nk != key || nv != ov;
                }
                catch (Exception t) {
                    throw new Exception("Unable to convert from " + obj + " to " + type + "(error converting map entry)", t);
                }
            }
            return converted ? newDic : obj;
        }
        Hashtable<Object, Object> newDic = new Hashtable<Object, Object>();
        for (Map.Entry e : ((Map)obj).entrySet()) {
            try {
                ((Dictionary)newDic).put(this.convert(e.getKey(), keyType), this.convert(e.getValue(), valueType));
            }
            catch (Exception t) {
                throw new Exception("Unable to convert from " + obj + " to " + type + "(error converting map entry)", t);
            }
        }
        return newDic;
    }

    private Object convertToMap(Object obj, ReifiedType type) throws Exception {
        ReifiedType keyType = type.getActualTypeArgument(0);
        ReifiedType valueType = type.getActualTypeArgument(1);
        Map newMap = (Map)ReflectionUtils.newInstance(this.blueprintContainer.getAccessControlContext(), MapRecipe.getMap(this.toClass(type)));
        if (obj instanceof Dictionary) {
            Dictionary dic = (Dictionary)obj;
            Enumeration keyEnum = dic.keys();
            while (keyEnum.hasMoreElements()) {
                Object key = keyEnum.nextElement();
                try {
                    newMap.put(this.convert(key, keyType), this.convert(dic.get(key), valueType));
                }
                catch (Exception t) {
                    throw new Exception("Unable to convert from " + obj + " to " + type + "(error converting map entry)", t);
                }
            }
            return newMap;
        }
        boolean converted = false;
        for (Map.Entry e : ((Map)obj).entrySet()) {
            try {
                Object nk = this.convert(e.getKey(), keyType);
                Object nv = this.convert(e.getValue(), valueType);
                converted |= nk != e.getKey() || nv != e.getValue();
                newMap.put(nk, nv);
            }
            catch (Exception t) {
                throw new Exception("Unable to convert from " + obj + " to " + type + "(error converting map entry)", t);
            }
        }
        return converted ? newMap : obj;
    }

    private Object convertToArray(Object obj, ReifiedType type) throws Exception {
        if (obj instanceof Collection) {
            obj = ((Collection)obj).toArray();
        }
        if (!obj.getClass().isArray()) {
            throw new Exception("Unable to convert from " + obj + " to " + type);
        }
        Object componentType = type.size() > 0 ? type.getActualTypeArgument(0) : new GenericType(type.getRawClass().getComponentType());
        Object[] array = Array.newInstance(this.toClass((ReifiedType)componentType), Array.getLength(obj));
        boolean converted = array.getClass() != obj.getClass();
        for (int i = 0; i < Array.getLength(obj); ++i) {
            try {
                Object ov = Array.get(obj, i);
                Object nv = this.convert(ov, (ReifiedType)componentType);
                converted |= nv != ov;
                Array.set(array, i, nv);
                continue;
            }
            catch (Exception t) {
                throw new Exception("Unable to convert from " + obj + " to " + type + "(error converting array element)", t);
            }
        }
        return converted ? array : obj;
    }

    public static boolean isAssignable(Object source, ReifiedType target) {
        if (source == null) {
            return true;
        }
        if (target.size() == 0) {
            return AggregateConverter.unwrap(target.getRawClass()).isAssignableFrom(AggregateConverter.unwrap(source.getClass()));
        }
        return AggregateConverter.isTypeAssignable(new GenericType(source.getClass()), target);
    }

    public static boolean isTypeAssignable(ReifiedType from, ReifiedType to) {
        if (from.equals(to)) {
            return true;
        }
        if (from.getRawClass() == to.getRawClass()) {
            if (from.size() == to.size()) {
                boolean ok = true;
                for (int i = 0; i < from.size(); ++i) {
                    ReifiedType tt;
                    ReifiedType tf = from.getActualTypeArgument(i);
                    if (AggregateConverter.isWildcardCompatible(tf, tt = to.getActualTypeArgument(i))) continue;
                    ok = false;
                    break;
                }
                if (ok) {
                    return true;
                }
            }
        } else {
            ReifiedType t = AggregateConverter.getExactSuperType(from, to.getRawClass());
            if (t != null) {
                return AggregateConverter.isTypeAssignable(t, to);
            }
        }
        return false;
    }

    private static ReifiedType getExactSuperType(ReifiedType from, Class<?> to) {
        if (from.getRawClass() == to) {
            return from;
        }
        if (!to.isAssignableFrom(from.getRawClass())) {
            return null;
        }
        for (ReifiedType superType : AggregateConverter.getExactDirectSuperTypes(from)) {
            ReifiedType result = AggregateConverter.getExactSuperType(superType, to);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static ReifiedType[] getExactDirectSuperTypes(ReifiedType type) {
        int resultIndex;
        ReifiedType[] result;
        Class clazz = type.getRawClass();
        Type[] superInterfaces = clazz.getGenericInterfaces();
        Type superClass = clazz.getGenericSuperclass();
        if (superClass == null && superInterfaces.length == 0 && clazz.isInterface()) {
            return new ReifiedType[]{new GenericType((Type)((Object)Object.class))};
        }
        if (superClass == null) {
            result = new ReifiedType[superInterfaces.length];
            resultIndex = 0;
        } else {
            result = new ReifiedType[superInterfaces.length + 1];
            resultIndex = 1;
            result[0] = AggregateConverter.mapTypeParameters(superClass, type);
        }
        for (Type superInterface : superInterfaces) {
            result[resultIndex++] = AggregateConverter.mapTypeParameters(superInterface, type);
        }
        return result;
    }

    private static ReifiedType mapTypeParameters(Type toMapType, ReifiedType typeAndParams) {
        if (typeAndParams.size() == 0 && typeAndParams.getRawClass().getTypeParameters().length > 0) {
            return new GenericType(new GenericType(toMapType).getRawClass());
        }
        if (toMapType instanceof Class) {
            return new GenericType(toMapType);
        }
        HashMap map = new HashMap();
        for (int i = 0; i < typeAndParams.size(); ++i) {
            map.put(typeAndParams.getRawClass().getTypeParameters()[i], (GenericType)typeAndParams.getActualTypeArgument(i));
        }
        return AggregateConverter.map(map, toMapType);
    }

    private static GenericType map(Map<TypeVariable<?>, GenericType> map, Type type) {
        if (type instanceof Class) {
            return new GenericType(type);
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            if (!map.containsKey(type)) {
                throw new IllegalArgumentException("Unable to resolve TypeVariable: " + tv);
            }
            return map.get(type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            GenericType[] args = new GenericType[pType.getActualTypeArguments().length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = AggregateConverter.map(map, pType.getActualTypeArguments()[i]);
            }
            return new GenericType((Class)pType.getRawType(), args);
        }
        throw new RuntimeException("not implemented: mapping " + type.getClass() + " (" + type + ")");
    }

    private static boolean isWildcardCompatible(ReifiedType from, ReifiedType to) {
        GenericType.BoundType fromBoundType = GenericType.boundType(from);
        GenericType.BoundType toBoundType = GenericType.boundType(to);
        if (toBoundType == GenericType.BoundType.Extends) {
            return fromBoundType != GenericType.BoundType.Super && AggregateConverter.isTypeAssignable(from, GenericType.bound(to));
        }
        if (toBoundType == GenericType.BoundType.Super) {
            return fromBoundType != GenericType.BoundType.Extends && AggregateConverter.isTypeAssignable(GenericType.bound(to), from);
        }
        return fromBoundType == GenericType.BoundType.Exact && GenericType.bound(from).equals(GenericType.bound(to));
    }

    private static Class unwrap(Class c) {
        Class u = primitives.get(c);
        return u != null ? u : c;
    }

    public Object convert(Object source, Type target) throws Exception {
        return this.convert(source, new GenericType(target));
    }

    private Class toClass(ReifiedType type) {
        return type.getRawClass();
    }

    static {
        primitives.put(Byte.TYPE, Byte.class);
        primitives.put(Short.TYPE, Short.class);
        primitives.put(Character.TYPE, Character.class);
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Double.TYPE, Double.class);
        primitives.put(Boolean.TYPE, Boolean.class);
    }

    private static class ConversionResult {
        public final Converter converter;
        public final Object value;

        public ConversionResult(Converter converter, Object value) {
            this.converter = converter;
            this.value = value;
        }
    }

    public static interface Convertible {
        public Object convert(ReifiedType var1) throws Exception;
    }
}

