<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->
---
layout: page
title: How To Become A Committer

    
---

# How to become a committer

While there's no exact criteria for becoming a committer, there is a fairly
obvious path to becoming a committer.

For starters, one should be familiar with the [Apache Way ](http://www.apache.org/foundation/how-it-works.html), especially the part about meritocracy.

Second, participate in the mailing lists, help answer questions when you
can and do so in a respectful manner.  This is often more important than
writing amazing code.

Third, write code, add patches, stick with them and be patient.  Add unit
tests and documentation.  In general, tackling 3 or 4 decent patches is
where the bar is at, but it depends on the state of the project.  In the
earlier stages of the project, the bar is a bit lower, so it pays to join
early!

Finally, it is then up to someone to nominate them to the PMC.	Typically,
one of the existing committers does this by sending an email to the private
PMC mailing list (private@m.a.o, where m.a.o is mahout.apache.org) and then
the PMC votes on it.  Nominations often occur internal to the PMC as well.
