/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.cache.invalidating;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.DefaultProjectArtifactsCache;
import org.apache.maven.project.artifact.ProjectArtifactsCache;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.sisu.Priority;
import org.mvndaemon.mvnd.cache.Cache;
import org.mvndaemon.mvnd.cache.CacheFactory;
import org.mvndaemon.mvnd.cache.CacheRecord;

@Singleton
@Named
@Priority(value=10)
public class InvalidatingProjectArtifactsCache
extends DefaultProjectArtifactsCache {
    final Cache<ProjectArtifactsCache.Key, Record> cache;

    @Inject
    public InvalidatingProjectArtifactsCache(CacheFactory cacheFactory) {
        this.cache = cacheFactory.newCache();
    }

    public ProjectArtifactsCache.Key createKey(MavenProject project, Collection<String> scopesToCollect, Collection<String> scopesToResolve, boolean aggregating, RepositorySystemSession session) {
        return new CacheKey(project, project.getRemoteProjectRepositories(), scopesToCollect, scopesToResolve, aggregating, session);
    }

    public ProjectArtifactsCache.CacheRecord get(ProjectArtifactsCache.Key key) throws LifecycleExecutionException {
        Record r = this.cache.get(key);
        if (r != null) {
            if (r.record.getException() != null) {
                throw r.record.getException();
            }
            return r.record;
        }
        return null;
    }

    public ProjectArtifactsCache.CacheRecord put(ProjectArtifactsCache.Key key, Set<Artifact> pluginArtifacts) {
        ProjectArtifactsCache.CacheRecord record = super.put(key, pluginArtifacts);
        ((DefaultProjectArtifactsCache)this).cache.remove(key);
        this.cache.put(key, new Record(record));
        return record;
    }

    public ProjectArtifactsCache.CacheRecord put(ProjectArtifactsCache.Key key, LifecycleExecutionException e) {
        ProjectArtifactsCache.CacheRecord record = super.put(key, e);
        ((DefaultProjectArtifactsCache)this).cache.remove(key);
        this.cache.put(key, new Record(record));
        return record;
    }

    public void flush() {
        this.cache.clear();
    }

    public void register(MavenProject project, ProjectArtifactsCache.Key cacheKey, ProjectArtifactsCache.CacheRecord record) {
    }

    protected static class CacheKey
    implements ProjectArtifactsCache.Key {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final Set<String> dependencyArtifacts;
        private final WorkspaceRepository workspace;
        private final LocalRepository localRepo;
        private final List<RemoteRepository> repositories;
        private final Set<String> collect;
        private final Set<String> resolve;
        private boolean aggregating;
        private final int hashCode;

        public CacheKey(MavenProject project, List<RemoteRepository> repositories, Collection<String> scopesToCollect, Collection<String> scopesToResolve, boolean aggregating, RepositorySystemSession session) {
            this.groupId = project.getGroupId();
            this.artifactId = project.getArtifactId();
            this.version = project.getVersion();
            LinkedHashSet<String> deps = new LinkedHashSet<String>();
            if (project.getDependencyArtifacts() != null) {
                for (Artifact dep : project.getDependencyArtifacts()) {
                    deps.add(dep.toString());
                }
            }
            this.dependencyArtifacts = Collections.unmodifiableSet(deps);
            this.workspace = RepositoryUtils.getWorkspace((RepositorySystemSession)session);
            this.localRepo = session.getLocalRepository();
            this.repositories = new ArrayList<RemoteRepository>(repositories.size());
            for (RemoteRepository repository : repositories) {
                if (repository.isRepositoryManager()) {
                    this.repositories.addAll(repository.getMirroredRepositories());
                    continue;
                }
                this.repositories.add(repository);
            }
            this.collect = scopesToCollect == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(scopesToCollect));
            this.resolve = scopesToResolve == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(scopesToResolve));
            this.aggregating = aggregating;
            int hash = 17;
            hash = hash * 31 + Objects.hashCode(this.groupId);
            hash = hash * 31 + Objects.hashCode(this.artifactId);
            hash = hash * 31 + Objects.hashCode(this.version);
            hash = hash * 31 + Objects.hashCode(this.dependencyArtifacts);
            hash = hash * 31 + Objects.hashCode(this.workspace);
            hash = hash * 31 + Objects.hashCode(this.localRepo);
            hash = hash * 31 + RepositoryUtils.repositoriesHashCode(repositories);
            hash = hash * 31 + Objects.hashCode(this.collect);
            hash = hash * 31 + Objects.hashCode(this.resolve);
            this.hashCode = hash = hash * 31 + Objects.hashCode(aggregating);
        }

        public boolean matches(String groupId, String artifactId, String version) {
            return Objects.equals(this.groupId, groupId) && Objects.equals(this.artifactId, artifactId) && Objects.equals(this.version, version);
        }

        public String toString() {
            return this.groupId + ":" + this.artifactId + ":" + this.version;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version) && Objects.equals(this.dependencyArtifacts, that.dependencyArtifacts) && Objects.equals(this.workspace, that.workspace) && Objects.equals(this.localRepo, that.localRepo) && RepositoryUtils.repositoriesEquals(this.repositories, that.repositories) && Objects.equals(this.collect, that.collect) && Objects.equals(this.resolve, that.resolve) && this.aggregating == that.aggregating;
        }
    }

    static class Record
    implements CacheRecord {
        private final ProjectArtifactsCache.CacheRecord record;

        public Record(ProjectArtifactsCache.CacheRecord record) {
            this.record = record;
        }

        @Override
        public Stream<Path> getDependencyPaths() {
            if (this.record.getException() != null) {
                return Stream.empty();
            }
            return this.record.getArtifacts().stream().map(Artifact::getFile).filter(Objects::nonNull).map(File::toPath);
        }

        @Override
        public void invalidate() {
        }
    }
}

