/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.cache.invalidating;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.plugin.ExtensionRealmCache;
import org.apache.maven.plugin.PluginRealmCache;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.Typed;
import org.mvndaemon.mvnd.cache.invalidating.InvalidatingExtensionRealmCache;
import org.mvndaemon.mvnd.cache.invalidating.InvalidatingPluginRealmCache;
import org.mvndaemon.mvnd.cache.invalidating.InvalidatingProjectArtifactsCache;
import org.mvndaemon.mvnd.common.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
@Typed(value={EventSpy.class})
public class InvalidatingRealmCacheEventSpy
extends AbstractEventSpy {
    private static final Logger LOG = LoggerFactory.getLogger(InvalidatingRealmCacheEventSpy.class);
    private final InvalidatingPluginRealmCache pluginCache;
    private final InvalidatingExtensionRealmCache extensionCache;
    private final InvalidatingProjectArtifactsCache projectArtifactsCache;
    private Path multiModuleProjectDirectory;
    private String pattern;
    private PathMatcher matcher;

    @Inject
    public InvalidatingRealmCacheEventSpy(InvalidatingPluginRealmCache cache, InvalidatingExtensionRealmCache extensionCache, InvalidatingProjectArtifactsCache projectArtifactsCache) {
        this.pluginCache = cache;
        this.extensionCache = extensionCache;
        this.projectArtifactsCache = projectArtifactsCache;
    }

    /*
     * WARNING - void declaration
     */
    public void onEvent(Object event) throws Exception {
        try {
            if (event instanceof MavenExecutionRequest) {
                this.multiModuleProjectDirectory = ((MavenExecutionRequest)event).getMultiModuleProjectDirectory().toPath();
                this.pattern = Environment.MVND_PLUGIN_REALM_EVICT_PATTERN.asOptional().orElse(Environment.MVND_PLUGIN_REALM_EVICT_PATTERN.getDefault());
                if (!this.pattern.isEmpty()) {
                    String[] patterns = this.pattern.split(",");
                    ArrayList<PathMatcher> matchers = new ArrayList<PathMatcher>();
                    for (String string : patterns) {
                        void var7_10;
                        if (string.startsWith("mvn:")) {
                            String artifactId;
                            String groupId;
                            String[] parts = string.substring("mvn:".length()).split(":");
                            String version = parts.length >= 3 ? parts[2] : "*";
                            if (parts.length >= 2) {
                                groupId = parts[0];
                                artifactId = parts[1];
                            } else {
                                groupId = "*";
                                artifactId = parts[0];
                            }
                            String string2 = "glob:**/" + (String)("*".equals(groupId) ? "" : groupId.replace('.', '/') + "/") + artifactId + "/" + (String)("*".equals(version) ? "**" : version + "/**");
                        }
                        matchers.add(InvalidatingRealmCacheEventSpy.getPathMatcher((String)var7_10));
                    }
                    this.matcher = matchers.size() == 1 ? (PathMatcher)matchers.iterator().next() : path -> matchers.stream().anyMatch(f -> f.matches(path));
                }
            } else if (event instanceof MavenExecutionResult) {
                this.pluginCache.cache.removeIf(this::shouldEvict);
                this.extensionCache.cache.removeIf(this::shouldEvict);
                MavenExecutionResult mer = (MavenExecutionResult)event;
                List projects = mer.getTopologicallySortedProjects();
                this.projectArtifactsCache.cache.removeIf((k, r) -> this.shouldEvict(projects, (InvalidatingProjectArtifactsCache.CacheKey)k, (InvalidatingProjectArtifactsCache.Record)r));
            }
        }
        catch (Exception e) {
            LOG.warn("Could not notify CliPluginRealmCache", (Throwable)e);
        }
    }

    private boolean shouldEvict(List<MavenProject> projects, InvalidatingProjectArtifactsCache.CacheKey k, InvalidatingProjectArtifactsCache.Record v) {
        return projects.stream().anyMatch(p -> k.matches(p.getGroupId(), p.getArtifactId(), p.getVersion()));
    }

    private boolean shouldEvict(PluginRealmCache.Key k, InvalidatingPluginRealmCache.Record v) {
        try {
            for (URL url : v.record.getRealm().getURLs()) {
                if (!url.getProtocol().equals("file")) continue;
                Path path = Paths.get(url.toURI());
                if (path.startsWith(this.multiModuleProjectDirectory)) {
                    LOG.debug("Removing PluginRealmCache entry {} because it refers to an artifact in the build tree {}", (Object)k, (Object)path);
                    return true;
                }
                if (this.matcher == null || !this.matcher.matches(path)) continue;
                LOG.debug("Removing PluginRealmCache entry {} because its components {} matches the eviction pattern '{}'", new Object[]{k, path, this.pattern});
                return true;
            }
            return false;
        }
        catch (URISyntaxException e) {
            return true;
        }
    }

    private boolean shouldEvict(ExtensionRealmCache.Key k, InvalidatingExtensionRealmCache.Record v) {
        try {
            for (URL url : v.record.getRealm().getURLs()) {
                if (!url.getProtocol().equals("file")) continue;
                Path path = Paths.get(url.toURI());
                if (path.startsWith(this.multiModuleProjectDirectory)) {
                    LOG.debug("Removing ExtensionRealmCache entry {} because it refers to an artifact in the build tree {}", (Object)k, (Object)path);
                    return true;
                }
                if (this.matcher == null || !this.matcher.matches(path)) continue;
                LOG.debug("Removing ExtensionRealmCache entry {} because its components {} matches the eviction pattern '{}'", new Object[]{k, path, this.pattern});
                return true;
            }
            return false;
        }
        catch (URISyntaxException e) {
            return true;
        }
    }

    private static PathMatcher getPathMatcher(String pattern) {
        if (!((String)pattern).startsWith("glob:") && !((String)pattern).startsWith("regex:")) {
            pattern = "glob:" + (String)pattern;
        }
        return FileSystems.getDefault().getPathMatcher((String)pattern);
    }
}

