/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.metadata;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.metadata.AbstractMetadata;
import org.eclipse.aether.metadata.Metadata;

public final class DefaultMetadata
extends AbstractMetadata {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String type;
    private final Metadata.Nature nature;
    private final Path path;
    private final Map<String, String> properties;

    public DefaultMetadata(String type, Metadata.Nature nature) {
        this("", "", "", type, nature, null, (Path)null);
    }

    public DefaultMetadata(String groupId, String type, Metadata.Nature nature) {
        this(groupId, "", "", type, nature, null, (Path)null);
    }

    public DefaultMetadata(String groupId, String artifactId, String type, Metadata.Nature nature) {
        this(groupId, artifactId, "", type, nature, null, (Path)null);
    }

    public DefaultMetadata(String groupId, String artifactId, String version, String type, Metadata.Nature nature) {
        this(groupId, artifactId, version, type, nature, null, (Path)null);
    }

    @Deprecated
    public DefaultMetadata(String groupId, String artifactId, String version, String type, Metadata.Nature nature, File file) {
        this(groupId, artifactId, version, type, nature, null, file);
    }

    public DefaultMetadata(String groupId, String artifactId, String version, String type, Metadata.Nature nature, Path path) {
        this(groupId, artifactId, version, type, nature, null, path);
    }

    @Deprecated
    public DefaultMetadata(String groupId, String artifactId, String version, String type, Metadata.Nature nature, Map<String, String> properties, File file) {
        this.groupId = DefaultMetadata.emptify(groupId);
        this.artifactId = DefaultMetadata.emptify(artifactId);
        this.version = DefaultMetadata.emptify(version);
        this.type = DefaultMetadata.emptify(type);
        this.nature = Objects.requireNonNull(nature, "metadata nature cannot be null");
        this.path = file != null ? file.toPath() : null;
        this.properties = DefaultMetadata.copyProperties(properties);
    }

    public DefaultMetadata(String groupId, String artifactId, String version, String type, Metadata.Nature nature, Map<String, String> properties, Path path) {
        this.groupId = DefaultMetadata.emptify(groupId);
        this.artifactId = DefaultMetadata.emptify(artifactId);
        this.version = DefaultMetadata.emptify(version);
        this.type = DefaultMetadata.emptify(type);
        this.nature = Objects.requireNonNull(nature, "metadata nature cannot be null");
        this.path = path;
        this.properties = DefaultMetadata.copyProperties(properties);
    }

    DefaultMetadata(String groupId, String artifactId, String version, String type, Metadata.Nature nature, Path path, Map<String, String> properties) {
        this.groupId = DefaultMetadata.emptify(groupId);
        this.artifactId = DefaultMetadata.emptify(artifactId);
        this.version = DefaultMetadata.emptify(version);
        this.type = DefaultMetadata.emptify(type);
        this.nature = nature;
        this.path = path;
        this.properties = properties;
    }

    private static String emptify(String str) {
        return str == null ? "" : str;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Metadata.Nature getNature() {
        return this.nature;
    }

    @Override
    @Deprecated
    public File getFile() {
        return this.path != null ? this.path.toFile() : null;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }
}

