/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.apache.maven.api.DependencyCoordinates;
import org.apache.maven.api.Language;
import org.apache.maven.api.Packaging;
import org.apache.maven.api.ProducedArtifact;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Profile;

@Experimental
public interface Project {
    @Nonnull
    public String getGroupId();

    @Nonnull
    public String getArtifactId();

    @Nonnull
    public String getVersion();

    @Nonnull
    public Packaging getPackaging();

    @Nonnull
    default public Language getLanguage() {
        return this.getPackaging().language();
    }

    @Nonnull
    default public ProducedArtifact getPomArtifact() {
        return this.getArtifacts().get(0);
    }

    @Nonnull
    default public Optional<ProducedArtifact> getMainArtifact() {
        List<ProducedArtifact> artifacts = this.getArtifacts();
        return artifacts.size() == 2 ? Optional.of(artifacts.get(1)) : Optional.empty();
    }

    @Nonnull
    public List<ProducedArtifact> getArtifacts();

    @Nonnull
    public Model getModel();

    @Nonnull
    default public Build getBuild() {
        Build build = this.getModel().getBuild();
        return build != null ? build : Build.newInstance();
    }

    @Nonnull
    public Path getPomPath();

    @Nonnull
    public Path getBasedir();

    @Nonnull
    public List<DependencyCoordinates> getDependencies();

    @Nonnull
    public List<DependencyCoordinates> getManagedDependencies();

    @Nonnull
    default public String getId() {
        return this.getModel().getId();
    }

    public boolean isTopProject();

    public boolean isRootProject();

    @Nonnull
    public Path getRootDirectory();

    @Nonnull
    public Optional<Project> getParent();

    @Nonnull
    public List<Profile> getDeclaredProfiles();

    @Nonnull
    public List<Profile> getEffectiveProfiles();

    @Nonnull
    public List<Profile> getDeclaredActiveProfiles();

    @Nonnull
    public List<Profile> getEffectiveActiveProfiles();
}

