/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.FileSet;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Source
extends FileSet
implements Serializable,
InputLocationTracker {
    final String scope;
    final String lang;
    final String module;
    final String targetVersion;
    final String targetPath;
    final boolean stringFiltering;
    final boolean enabled;

    protected Source(Builder builder) {
        super(builder);
        String string = builder.scope != null ? builder.scope : (this.scope = builder.base != null ? builder.base.scope : null);
        String string2 = builder.lang != null ? builder.lang : (this.lang = builder.base != null ? builder.base.lang : null);
        String string3 = builder.module != null ? builder.module : (this.module = builder.base != null ? builder.base.module : null);
        String string4 = builder.targetVersion != null ? builder.targetVersion : (this.targetVersion = builder.base != null ? builder.base.targetVersion : null);
        String string5 = builder.targetPath != null ? builder.targetPath : (this.targetPath = builder.base != null ? builder.base.targetPath : null);
        boolean bl = builder.stringFiltering != null ? builder.stringFiltering : (this.stringFiltering = builder.base != null ? builder.base.stringFiltering : false);
        this.enabled = builder.enabled != null ? builder.enabled : (builder.base != null ? builder.base.enabled : true);
    }

    public String getScope() {
        return this.scope;
    }

    public String getLang() {
        return this.lang;
    }

    public String getModule() {
        return this.module;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public boolean isStringFiltering() {
        return this.stringFiltering;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Source.newBuilder(this);
    }

    @Override
    @Nonnull
    public Source withIncludes(Collection<String> includes) {
        return ((Builder)Source.newBuilder(this, true).includes((Collection)includes)).build();
    }

    @Override
    @Nonnull
    public Source withExcludes(Collection<String> excludes) {
        return ((Builder)Source.newBuilder(this, true).excludes((Collection)excludes)).build();
    }

    @Override
    @Nonnull
    public Source withDirectory(String directory) {
        return Source.newBuilder(this, true).directory(directory).build();
    }

    @Nonnull
    public Source withScope(String scope) {
        return Source.newBuilder(this, true).scope(scope).build();
    }

    @Nonnull
    public Source withLang(String lang) {
        return Source.newBuilder(this, true).lang(lang).build();
    }

    @Nonnull
    public Source withModule(String module) {
        return Source.newBuilder(this, true).module(module).build();
    }

    @Nonnull
    public Source withTargetVersion(String targetVersion) {
        return Source.newBuilder(this, true).targetVersion(targetVersion).build();
    }

    @Nonnull
    public Source withTargetPath(String targetPath) {
        return Source.newBuilder(this, true).targetPath(targetPath).build();
    }

    @Nonnull
    public Source withStringFiltering(boolean stringFiltering) {
        return Source.newBuilder(this, true).stringFiltering(stringFiltering).build();
    }

    @Nonnull
    public Source withEnabled(boolean enabled) {
        return Source.newBuilder(this, true).enabled(enabled).build();
    }

    @Nonnull
    public static Source newInstance() {
        return Source.newInstance(true);
    }

    @Nonnull
    public static Source newInstance(boolean withDefaults) {
        return Source.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Source.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Source from) {
        return Source.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Source from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder
    extends FileSet.Builder {
        Source base;
        String scope;
        String lang;
        String module;
        String targetVersion;
        String targetPath;
        Boolean stringFiltering;
        Boolean enabled;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.scope = "main";
                this.lang = "java";
                this.stringFiltering = false;
                this.enabled = true;
            }
        }

        protected Builder(Source base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.scope = base.scope;
                this.lang = base.lang;
                this.module = base.module;
                this.targetVersion = base.targetVersion;
                this.targetPath = base.targetPath;
                this.stringFiltering = base.stringFiltering;
                this.enabled = base.enabled;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder includes(Collection<String> includes) {
            this.includes = includes;
            return this;
        }

        @Override
        @Nonnull
        public Builder excludes(Collection<String> excludes) {
            this.excludes = excludes;
            return this;
        }

        @Override
        @Nonnull
        public Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        @Nonnull
        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Nonnull
        public Builder lang(String lang) {
            this.lang = lang;
            return this;
        }

        @Nonnull
        public Builder module(String module) {
            this.module = module;
            return this;
        }

        @Nonnull
        public Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        @Nonnull
        public Builder targetPath(String targetPath) {
            this.targetPath = targetPath;
            return this;
        }

        @Nonnull
        public Builder stringFiltering(boolean stringFiltering) {
            this.stringFiltering = stringFiltering;
            return this;
        }

        @Nonnull
        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Override
        @Nonnull
        public Source build() {
            if (!(this.base == null || this.includes != null && this.includes != this.base.includes || this.excludes != null && this.excludes != this.base.excludes || this.directory != null && this.directory != this.base.directory || this.scope != null && this.scope != this.base.scope || this.lang != null && this.lang != this.base.lang || this.module != null && this.module != this.base.module || this.targetVersion != null && this.targetVersion != this.base.targetVersion || this.targetPath != null && this.targetPath != this.base.targetPath || this.stringFiltering != null && this.stringFiltering != this.base.stringFiltering || this.enabled != null && this.enabled != this.base.enabled)) {
                return this.base;
            }
            return new Source(this);
        }
    }
}

