/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.AbstractMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.config.keys.ClientIdentityLoader;
import org.apache.sshd.client.config.keys.ClientIdentityLoaderHolder;
import org.apache.sshd.client.config.keys.ClientIdentityProvider;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.FilePasswordProviderHolder;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;
import org.apache.sshd.common.util.io.resource.PathResource;

public class ClientIdentityFileWatcher
extends ModifiableFileWatcher
implements ClientIdentityProvider,
ClientIdentityLoaderHolder,
FilePasswordProviderHolder {
    private final AtomicReference<Iterable<KeyPair>> identitiesHolder = new AtomicReference<Object>(null);
    private final ClientIdentityLoaderHolder loaderHolder;
    private final FilePasswordProviderHolder providerHolder;
    private final boolean strict;

    public ClientIdentityFileWatcher(Path path, ClientIdentityLoader loader, FilePasswordProvider provider) {
        this(path, loader, provider, true);
    }

    public ClientIdentityFileWatcher(Path path, ClientIdentityLoader loader, FilePasswordProvider provider, boolean strict) {
        this(path, ClientIdentityLoaderHolder.loaderHolderOf(Objects.requireNonNull(loader, "No client identity loader")), FilePasswordProviderHolder.providerHolderOf(Objects.requireNonNull(provider, "No password provider")), strict);
    }

    public ClientIdentityFileWatcher(Path path, ClientIdentityLoaderHolder loader, FilePasswordProviderHolder provider) {
        this(path, loader, provider, true);
    }

    public ClientIdentityFileWatcher(Path path, ClientIdentityLoaderHolder loader, FilePasswordProviderHolder provider, boolean strict) {
        super(path);
        this.loaderHolder = Objects.requireNonNull(loader, "No client identity loader");
        this.providerHolder = Objects.requireNonNull(provider, "No password provider");
        this.strict = strict;
    }

    public boolean isStrict() {
        return this.strict;
    }

    @Override
    public ClientIdentityLoader getClientIdentityLoader() {
        return this.loaderHolder.getClientIdentityLoader();
    }

    @Override
    public FilePasswordProvider getFilePasswordProvider() {
        return this.providerHolder.getFilePasswordProvider();
    }

    @Override
    public Iterable<KeyPair> getClientIdentities(SessionContext session) throws IOException, GeneralSecurityException {
        if (!this.checkReloadRequired()) {
            return this.identitiesHolder.get();
        }
        this.identitiesHolder.set(null);
        Path path = this.getPath();
        if (!this.exists()) {
            return this.identitiesHolder.get();
        }
        Iterable<KeyPair> kp = this.reloadClientIdentities(session, path);
        this.updateReloadAttributes();
        this.identitiesHolder.set(kp);
        return kp;
    }

    protected Iterable<KeyPair> reloadClientIdentities(SessionContext session, Path path) throws IOException, GeneralSecurityException {
        AbstractMap.SimpleImmutableEntry<String, Object> violation;
        if (this.isStrict() && (violation = KeyUtils.validateStrictKeyFilePermissions(path, IoUtils.EMPTY_LINK_OPTIONS)) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("reloadClientIdentity({}) ignore due to {}", (Object)path, violation.getKey());
            }
            return null;
        }
        PathResource location = new PathResource(path);
        ClientIdentityLoader idLoader = Objects.requireNonNull(this.getClientIdentityLoader(), "No client identity loader");
        if (idLoader.isValidLocation(location)) {
            Iterable<KeyPair> ids = idLoader.loadClientIdentities(session, location, this.getFilePasswordProvider());
            if (this.log.isTraceEnabled()) {
                if (ids == null) {
                    this.log.trace("reloadClientIdentity({}) no keys loaded", (Object)location);
                } else {
                    for (KeyPair kp : ids) {
                        PublicKey key = kp == null ? null : kp.getPublic();
                        if (key == null) continue;
                        this.log.trace("reloadClientIdentity({}) loaded {}-{}", new Object[]{location, KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key)});
                    }
                }
            }
            return ids;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("reloadClientIdentity({}) invalid location", (Object)location);
        }
        return null;
    }
}

