/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0045_muc.model;

import java.util.EnumSet;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Affiliation;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Privilege {
    PresentInRoom,
    ReceiveMessages,
    ReceiveOccupantPresence,
    PresenceBroadcastedToRoom,
    ChangeAvailabilityStatus,
    ChangeRoomNickname,
    SendPrivateMessages,
    InviteOtherUsers,
    SendMessagesToAll,
    ModifySubject,
    KickParticipantsAndVisitors,
    GrantVoice,
    RevokeVoice,
    EnterOpenRoom,
    RegisterWithOpenRoom,
    RetrieveMemberList,
    EnterMembersOnlyRoom,
    BanMembersAndUnaffiliatedUsers,
    EditMemberList,
    EditModeratorList,
    EditAdminList,
    EditOwnerList,
    ChangeRoomDefinition,
    DestroyRoom;

    private static EnumSet<Privilege> MODERATOR_PRIVILEGES;
    private static EnumSet<Privilege> PARTICIPANT_PRIVILEGES;
    private static EnumSet<Privilege> VISITOR_PRIVILEGES;
    private static EnumSet<Privilege> NONE_ROLE_PRIVILEGES;
    private static EnumSet<Privilege> OWNER_PRIVILEGES;
    private static EnumSet<Privilege> ADMIN_PRIVILEGES;
    private static EnumSet<Privilege> MEMBER_PRIVILEGES;
    private static EnumSet<Privilege> NONE_AFFILIATION_PRIVILEGES;
    private static EnumSet<Privilege> OUTCATS_PRIVILEGES;

    public static EnumSet<Privilege> getPrivileges(Role role) {
        switch (role) {
            case Moderator: {
                return MODERATOR_PRIVILEGES;
            }
            case Participant: {
                return PARTICIPANT_PRIVILEGES;
            }
            case Visitor: {
                return VISITOR_PRIVILEGES;
            }
        }
        return NONE_ROLE_PRIVILEGES;
    }

    public static EnumSet<Privilege> getPrivileges(Affiliation affiliation) {
        switch (affiliation) {
            case Owner: {
                return OWNER_PRIVILEGES;
            }
            case Admin: {
                return ADMIN_PRIVILEGES;
            }
            case Member: {
                return MEMBER_PRIVILEGES;
            }
            case None: {
                return NONE_AFFILIATION_PRIVILEGES;
            }
        }
        return OUTCATS_PRIVILEGES;
    }

    static {
        MODERATOR_PRIVILEGES = EnumSet.of(PresentInRoom, new Privilege[]{ReceiveMessages, ReceiveOccupantPresence, PresenceBroadcastedToRoom, ChangeAvailabilityStatus, ChangeRoomNickname, SendPrivateMessages, InviteOtherUsers, SendMessagesToAll, ModifySubject, KickParticipantsAndVisitors, GrantVoice, RevokeVoice});
        PARTICIPANT_PRIVILEGES = EnumSet.of(PresentInRoom, new Privilege[]{ReceiveMessages, ReceiveOccupantPresence, PresenceBroadcastedToRoom, ChangeAvailabilityStatus, ChangeRoomNickname, SendPrivateMessages, InviteOtherUsers, SendMessagesToAll, ModifySubject});
        VISITOR_PRIVILEGES = EnumSet.of(PresentInRoom, new Privilege[]{ReceiveMessages, ReceiveOccupantPresence, PresenceBroadcastedToRoom, ChangeAvailabilityStatus, ChangeRoomNickname, SendPrivateMessages, InviteOtherUsers});
        NONE_ROLE_PRIVILEGES = EnumSet.noneOf(Privilege.class);
        OWNER_PRIVILEGES = EnumSet.of(EnterOpenRoom, new Privilege[]{RegisterWithOpenRoom, RetrieveMemberList, EnterMembersOnlyRoom, BanMembersAndUnaffiliatedUsers, EditMemberList, EditModeratorList, EditAdminList, EditOwnerList, ChangeRoomDefinition, DestroyRoom});
        ADMIN_PRIVILEGES = EnumSet.of(EnterOpenRoom, new Privilege[]{RegisterWithOpenRoom, RetrieveMemberList, EnterMembersOnlyRoom, BanMembersAndUnaffiliatedUsers, EditMemberList, EditModeratorList});
        MEMBER_PRIVILEGES = EnumSet.of(EnterOpenRoom, RegisterWithOpenRoom, RetrieveMemberList, EnterMembersOnlyRoom);
        NONE_AFFILIATION_PRIVILEGES = EnumSet.of(EnterOpenRoom, RegisterWithOpenRoom);
        OUTCATS_PRIVILEGES = EnumSet.noneOf(Privilege.class);
    }
}

