/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.owner;

import java.util.List;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityFormatException;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.AffiliationItem;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.CollectingMemberAffiliationVisitor;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.PubSubAffiliation;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.PubSubPrivilege;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.PubSubServiceConfiguration;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.owner.AbstractPubSubOwnerHandler;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.CollectionNode;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.LastOwnerResignedException;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.LeafNode;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PubSubOwnerManageAffiliationsHandler
extends AbstractPubSubOwnerHandler {
    public PubSubOwnerManageAffiliationsHandler(PubSubServiceConfiguration serviceConfiguration) {
        super(serviceConfiguration);
    }

    @Override
    protected String getWorkerElement() {
        return "affiliations";
    }

    protected Stanza handleGet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        Entity serverJID = this.serviceConfiguration.getDomainJID();
        CollectionNode root = this.serviceConfiguration.getRootNode();
        Entity sender = PubSubOwnerManageAffiliationsHandler.extractSenderJID((XMPPCoreStanza)stanza, (SessionContext)sessionContext);
        StanzaBuilder sb = StanzaBuilder.createDirectReply((XMPPCoreStanza)stanza, (boolean)false, (IQStanzaType)IQStanzaType.RESULT);
        sb.startInnerElement("pubsub", "http://jabber.org/protocol/pubsub#owner");
        String nodeName = this.extractNodeName(stanza);
        LeafNode node = root.find(nodeName);
        if (node == null) {
            return this.errorStanzaGenerator.generateNoNodeErrorStanza(sender, serverJID, stanza);
        }
        if (!node.isAuthorized(sender, PubSubPrivilege.MANAGE_AFFILIATIONS)) {
            return this.errorStanzaGenerator.generateInsufficientPrivilegesErrorStanza(sender, serverJID, stanza);
        }
        List<AffiliationItem> affiliations = this.collectAllAffiliations(node);
        this.buildSuccessStanza(sb, node, affiliations);
        sb.endInnerElement();
        return new IQStanza((Stanza)sb.build());
    }

    protected Stanza handleSet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        Entity serverJID = this.serviceConfiguration.getDomainJID();
        CollectionNode root = this.serviceConfiguration.getRootNode();
        Entity sender = PubSubOwnerManageAffiliationsHandler.extractSenderJID((XMPPCoreStanza)stanza, (SessionContext)sessionContext);
        StanzaBuilder sb = StanzaBuilder.createDirectReply((XMPPCoreStanza)stanza, (boolean)false, (IQStanzaType)IQStanzaType.RESULT);
        sb.startInnerElement("pubsub", "http://jabber.org/protocol/pubsub#owner");
        String nodeName = this.extractNodeName(stanza);
        LeafNode node = root.find(nodeName);
        if (node == null) {
            return this.errorStanzaGenerator.generateNoNodeErrorStanza(sender, serverJID, stanza);
        }
        if (!node.isAuthorized(sender, PubSubPrivilege.MANAGE_AFFILIATIONS)) {
            return this.errorStanzaGenerator.generateInsufficientPrivilegesErrorStanza(sender, serverJID, stanza);
        }
        XMLElement affiliationElement = null;
        try {
            if (stanza.getFirstInnerElement().getFirstInnerElement().getInnerElements().size() != 1) {
                return this.errorStanzaGenerator.generateNotAcceptableErrorStanza(serverJID, sender, stanza);
            }
            affiliationElement = stanza.getFirstInnerElement().getFirstInnerElement().getFirstInnerElement();
            EntityImpl userJID = null;
            try {
                userJID = EntityImpl.parse((String)affiliationElement.getAttributeValue("jid"));
            }
            catch (EntityFormatException e) {
                return this.errorStanzaGenerator.generateJIDMalformedErrorStanza(serverJID, sender, stanza);
            }
            PubSubAffiliation newAffiliation = PubSubAffiliation.get(affiliationElement.getAttributeValue("affiliation"));
            node.setAffiliation((Entity)userJID, newAffiliation);
        }
        catch (LastOwnerResignedException e) {
            return this.errorStanzaGenerator.generateNotAcceptableErrorStanza(serverJID, sender, stanza);
        }
        catch (Throwable t) {
            return this.errorStanzaGenerator.generateBadRequestErrorStanza(serverJID, sender, stanza);
        }
        sb.endInnerElement();
        return new IQStanza((Stanza)sb.build());
    }

    private void buildSuccessStanza(StanzaBuilder sb, LeafNode node, List<AffiliationItem> affiliations) {
        sb.startInnerElement("affiliations", "http://jabber.org/protocol/pubsub");
        sb.addAttribute("node", node.getName());
        for (AffiliationItem i : affiliations) {
            sb.startInnerElement("affiliation", "http://jabber.org/protocol/pubsub");
            sb.addAttribute("jid", i.getJID().getFullQualifiedName());
            sb.addAttribute("affiliation", i.getAffiliation().toString());
            sb.endInnerElement();
        }
        sb.endInnerElement();
    }

    private List<AffiliationItem> collectAllAffiliations(LeafNode node) {
        CollectingMemberAffiliationVisitor memberAffiliationVisitor = new CollectingMemberAffiliationVisitor(node.getName());
        node.acceptMemberAffiliations(memberAffiliationVisitor);
        List<AffiliationItem> affiliations = memberAffiliationVisitor.getAffiliations();
        return affiliations;
    }
}

