/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherSerializationListener;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class EscherContainerRecord
extends EscherRecord {
    public static final short DGG_CONTAINER = -4096;
    public static final short BSTORE_CONTAINER = -4095;
    public static final short DG_CONTAINER = -4094;
    public static final short SPGR_CONTAINER = -4093;
    public static final short SP_CONTAINER = -4092;
    public static final short SOLVER_CONTAINER = -4091;
    private List childRecords = new ArrayList();

    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, offset);
        int bytesWritten = 8;
        offset += 8;
        while (bytesRemaining > 0 && offset < data.length) {
            EscherRecord child = recordFactory.createRecord(data, offset);
            int childBytesWritten = child.fillFields(data, offset, recordFactory);
            bytesWritten += childBytesWritten;
            this.getChildRecords().add(child);
            if ((offset += childBytesWritten) < data.length || (bytesRemaining -= childBytesWritten) <= 0) continue;
            System.out.println("WARNING: " + bytesRemaining + " bytes remaining but no space left");
        }
        return bytesWritten;
    }

    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        LittleEndian.putShort(data, offset, this.getOptions());
        LittleEndian.putShort(data, offset + 2, this.getRecordId());
        int remainingBytes = 0;
        Iterator iterator = this.getChildRecords().iterator();
        while (iterator.hasNext()) {
            EscherRecord r = (EscherRecord)iterator.next();
            remainingBytes += r.getRecordSize();
        }
        LittleEndian.putInt(data, offset + 4, remainingBytes);
        int pos = offset + 8;
        Iterator iterator2 = this.getChildRecords().iterator();
        while (iterator2.hasNext()) {
            EscherRecord r = (EscherRecord)iterator2.next();
            pos += r.serialize(pos, data, listener);
        }
        listener.afterRecordSerialize(pos, this.getRecordId(), pos - offset, this);
        return pos - offset;
    }

    public int getRecordSize() {
        int childRecordsSize = 0;
        Iterator iterator = this.getChildRecords().iterator();
        while (iterator.hasNext()) {
            EscherRecord r = (EscherRecord)iterator.next();
            childRecordsSize += r.getRecordSize();
        }
        return 8 + childRecordsSize;
    }

    public List getChildRecords() {
        return this.childRecords;
    }

    public void setChildRecords(List childRecords) {
        this.childRecords = childRecords;
    }

    public String getRecordName() {
        switch (this.getRecordId()) {
            case -4096: {
                return "DggContainer";
            }
            case -4095: {
                return "BStoreContainer";
            }
            case -4094: {
                return "DgContainer";
            }
            case -4093: {
                return "SpgrContainer";
            }
            case -4092: {
                return "SpContainer";
            }
            case -4091: {
                return "SolverContainer";
            }
        }
        return "Container 0x" + HexDump.toHex(this.getRecordId());
    }

    public void display(PrintWriter w, int indent) {
        super.display(w, indent);
        Iterator iterator = this.childRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            escherRecord.display(w, indent + 1);
        }
    }

    public void addChildRecord(EscherRecord record) {
        this.childRecords.add(record);
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer children = new StringBuffer();
        if (this.getChildRecords().size() > 0) {
            children.append("  children: " + nl);
            Iterator iterator = this.getChildRecords().iterator();
            while (iterator.hasNext()) {
                EscherRecord record = (EscherRecord)iterator.next();
                children.append(record.toString());
            }
        }
        return this.getClass().getName() + " (" + this.getRecordName() + "):" + nl + "  isContainer: " + this.isContainerRecord() + nl + "  options: 0x" + HexDump.toHex(this.getOptions()) + nl + "  recordId: 0x" + HexDump.toHex(this.getRecordId()) + nl + "  numchildren: " + this.getChildRecords().size() + nl + children.toString();
    }

    public EscherSpRecord getChildById(short recordId) {
        Iterator iterator = this.childRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            if (escherRecord.getRecordId() != recordId) continue;
            return (EscherSpRecord)escherRecord;
        }
        return null;
    }
}

