/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Cell;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.PdfCell;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfTable
extends Rectangle {
    private int columns;
    private ArrayList headercells;
    private ArrayList cells;
    protected Table table;
    protected float[] positions;

    PdfTable(Table table, float left, float right, float top, boolean supportUpdateRowAdditions) {
        super(left, top, right, top);
        this.table = table;
        table.complete();
        this.cloneNonPositionParameters(table);
        this.columns = table.columns();
        this.positions = table.getWidths(left, right - left);
        this.setLeft(this.positions[0]);
        this.setRight(this.positions[this.positions.length - 1]);
        this.headercells = new ArrayList();
        this.cells = new ArrayList();
        this.updateRowAdditionsInternal();
        if (supportUpdateRowAdditions) {
            table.deleteAllRows();
        }
    }

    void updateRowAdditions() {
        this.table.complete();
        this.updateRowAdditionsInternal();
        this.table.deleteAllRows();
    }

    private void updateRowAdditionsInternal() {
        PdfCell currentCell;
        int i;
        int prevRows = this.rows();
        int rowNumber = 0;
        int groupNumber = 0;
        int firstDataRow = this.table.firstDataRow();
        ArrayList<PdfCell> newCells = new ArrayList<PdfCell>();
        int rows = this.table.size() + 1;
        float[] offsets = new float[rows];
        int i2 = 0;
        while (i2 < rows) {
            offsets[i2] = this.bottom();
            ++i2;
        }
        Iterator rowIterator = this.table.iterator();
        while (rowIterator.hasNext()) {
            boolean groupChange = false;
            Row row = (Row)rowIterator.next();
            if (row.isEmpty()) {
                if (rowNumber < rows - 1 && offsets[rowNumber + 1] > offsets[rowNumber]) {
                    offsets[rowNumber + 1] = offsets[rowNumber];
                }
            } else {
                i = 0;
                while (i < row.columns()) {
                    Cell cell = (Cell)row.getCell(i);
                    if (cell != null) {
                        block14: {
                            currentCell = new PdfCell(cell, rowNumber + prevRows, this.positions[i], this.positions[i + cell.colspan()], offsets[rowNumber], this.cellspacing(), this.cellpadding());
                            try {
                                if (offsets[rowNumber] - currentCell.height() - this.cellpadding() < offsets[rowNumber + currentCell.rowspan()]) {
                                    offsets[rowNumber + currentCell.rowspan()] = offsets[rowNumber] - currentCell.height() - this.cellpadding();
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException aioobe) {
                                if (!(offsets[rowNumber] - currentCell.height() < offsets[rows - 1])) break block14;
                                offsets[rows - 1] = offsets[rowNumber] - currentCell.height();
                            }
                        }
                        if (rowNumber < firstDataRow) {
                            currentCell.setHeader();
                            this.headercells.add(currentCell);
                        }
                        currentCell.setGroupNumber(groupNumber);
                        groupChange |= cell.getGroupChange();
                        newCells.add(currentCell);
                    }
                    ++i;
                }
            }
            ++rowNumber;
            if (!groupChange) continue;
            ++groupNumber;
        }
        int n = newCells.size();
        i = 0;
        while (i < n) {
            currentCell = (PdfCell)newCells.get(i);
            try {
                currentCell.setBottom(offsets[currentCell.rownumber() - prevRows + currentCell.rowspan()]);
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                currentCell.setBottom(offsets[rows - 1]);
            }
            ++i;
        }
        this.cells.addAll(newCells);
        this.setBottom(offsets[rows - 1]);
    }

    int rows() {
        return this.cells.isEmpty() ? 0 : ((PdfCell)this.cells.get(this.cells.size() - 1)).rownumber() + 1;
    }

    public int type() {
        return 22;
    }

    ArrayList getHeaderCells() {
        return this.headercells;
    }

    boolean hasHeader() {
        return !this.headercells.isEmpty();
    }

    ArrayList getCells() {
        return this.cells;
    }

    int columns() {
        return this.columns;
    }

    final float cellpadding() {
        return this.table.cellpadding();
    }

    final float cellspacing() {
        return this.table.cellspacing();
    }

    public final boolean hasToFitPageTable() {
        return this.table.hasToFitPageTable();
    }

    public final boolean hasToFitPageCells() {
        return this.table.hasToFitPageCells();
    }

    public float getOffset() {
        return this.table.getOffset();
    }
}

