/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractThreadSafeAttributeMap<V>
extends AbstractMap<String, V> {
    private Set<String> _keySet = new KeySet();
    private Collection<V> _values = new Values();
    private Set<Map.Entry<String, V>> _entrySet = new EntrySet();

    @Override
    public void clear() {
        ArrayList<String> names = Collections.list(this.getAttributeNames());
        for (String name : names) {
            this.removeAttribute(name);
        }
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.getAttribute(key.toString()) != null;
    }

    @Override
    public boolean containsValue(Object findValue) {
        if (findValue == null) {
            return false;
        }
        Enumeration<String> e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            V value = this.getAttribute(e.nextElement());
            if (!findValue.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this._entrySet;
    }

    @Override
    public V get(Object key) {
        return this.getAttribute(key.toString());
    }

    @Override
    public boolean isEmpty() {
        return !this.getAttributeNames().hasMoreElements();
    }

    @Override
    public Set<String> keySet() {
        return this._keySet;
    }

    @Override
    public final V put(String key, V value) {
        V retval = this.getAttribute(key);
        this.setAttribute(key, value);
        return retval;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> t) {
        for (Map.Entry<String, V> entry : t.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public final V remove(Object key) {
        String key_ = key.toString();
        V retval = this.getAttribute(key_);
        this.removeAttribute(key_);
        return retval;
    }

    @Override
    public int size() {
        int size = 0;
        Enumeration<String> e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            ++size;
            e.nextElement();
        }
        return size;
    }

    @Override
    public Collection<V> values() {
        return this._values;
    }

    protected abstract V getAttribute(String var1);

    protected abstract void setAttribute(String var1, V var2);

    protected abstract void removeAttribute(String var1);

    protected abstract Enumeration<String> getAttributeNames();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntrySetEntry
    implements Map.Entry<String, V> {
        private final String _currentKey;

        public EntrySetEntry(String currentKey) {
            this._currentKey = currentKey;
        }

        @Override
        public String getKey() {
            return this._currentKey;
        }

        @Override
        public V getValue() {
            return AbstractThreadSafeAttributeMap.this.get(this._currentKey);
        }

        @Override
        public V setValue(V value) {
            return AbstractThreadSafeAttributeMap.this.put(this._currentKey, value);
        }

        @Override
        public int hashCode() {
            int result = 1;
            result = 31 * result + (this._currentKey == null ? 0 : this._currentKey.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntrySetEntry other = (EntrySetEntry)obj;
            return !(this._currentKey == null ? other._currentKey != null : !this._currentKey.equals(other._currentKey));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    extends AbstractAttributeIterator<Map.Entry<String, V>> {
        private EntryIterator() {
        }

        @Override
        protected Map.Entry<String, V> getValue(String attributeName) {
            return new EntrySetEntry(attributeName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntrySet
    extends AbstractAttributeSet<Map.Entry<String, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) {
                return false;
            }
            return value.equals(AbstractThreadSafeAttributeMap.this.get(key));
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null || !value.equals(AbstractThreadSafeAttributeMap.this.get(key))) {
                return false;
            }
            return AbstractThreadSafeAttributeMap.this.remove(((Map.Entry)o).getKey()) != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesIterator
    extends AbstractAttributeIterator<V> {
        private ValuesIterator() {
        }

        @Override
        protected V getValue(String attributeName) {
            return AbstractThreadSafeAttributeMap.this.get(attributeName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends AbstractAttributeSet<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValuesIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return false;
            }
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                return false;
            }
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                it.remove();
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeyIterator
    extends AbstractAttributeIterator<String> {
        private KeyIterator() {
        }

        @Override
        protected String getValue(String attributeName) {
            return attributeName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractAttributeIterator<E>
    implements Iterator<E> {
        protected final Iterator<String> _i;
        protected String _currentKey;

        private AbstractAttributeIterator() {
            this._i = Collections.list(AbstractThreadSafeAttributeMap.this.getAttributeNames()).iterator();
        }

        @Override
        public void remove() {
            if (this._currentKey == null) {
                throw new NoSuchElementException("You must call next() at least once");
            }
            AbstractThreadSafeAttributeMap.this.remove(this._currentKey);
        }

        @Override
        public boolean hasNext() {
            return this._i.hasNext();
        }

        @Override
        public E next() {
            this._currentKey = this._i.next();
            return this.getValue(this._currentKey);
        }

        protected abstract E getValue(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySet
    extends AbstractAttributeSet<String> {
        private KeySet() {
        }

        @Override
        public Iterator<String> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractThreadSafeAttributeMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractThreadSafeAttributeMap.this.remove(o) != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractAttributeSet<E>
    extends AbstractSet<E> {
        private AbstractAttributeSet() {
        }

        @Override
        public boolean isEmpty() {
            return AbstractThreadSafeAttributeMap.this.isEmpty();
        }

        @Override
        public int size() {
            return AbstractThreadSafeAttributeMap.this.size();
        }

        @Override
        public void clear() {
            AbstractThreadSafeAttributeMap.this.clear();
        }
    }
}

