/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.config.DefaultFacesConfigResourceProvider;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.spi.FacesConfigResourceProvider;
import org.apache.myfaces.spi.FacesConfigResourceProviderFactory;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;

public class DefaultFacesConfigResourceProviderFactory
extends FacesConfigResourceProviderFactory {
    public static final String FACES_CONFIG_PROVIDER = FacesConfigResourceProvider.class.getName();
    public static final String FACES_CONFIG_PROVIDER_LIST = FacesConfigResourceProvider.class.getName() + ".LIST";

    private Logger getLogger() {
        return Logger.getLogger(DefaultFacesConfigResourceProviderFactory.class.getName());
    }

    @Override
    public FacesConfigResourceProvider createFacesConfigResourceProvider(ExternalContext externalContext) {
        FacesConfigResourceProvider returnValue = null;
        final ExternalContext extContext = externalContext;
        try {
            returnValue = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedExceptionAction<FacesConfigResourceProvider>(){

                @Override
                public FacesConfigResourceProvider run() throws ClassNotFoundException, NoClassDefFoundError, InstantiationException, IllegalAccessException, InvocationTargetException, PrivilegedActionException {
                    return DefaultFacesConfigResourceProviderFactory.this.resolveFacesConfigResourceProviderFromService(extContext);
                }
            }) : this.resolveFacesConfigResourceProviderFromService(extContext);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (InstantiationException e) {
            this.getLogger().log(Level.SEVERE, "", e);
        }
        catch (IllegalAccessException e) {
            this.getLogger().log(Level.SEVERE, "", e);
        }
        catch (InvocationTargetException e) {
            this.getLogger().log(Level.SEVERE, "", e);
        }
        catch (PrivilegedActionException e) {
            throw new FacesException(e);
        }
        return returnValue;
    }

    private FacesConfigResourceProvider resolveFacesConfigResourceProviderFromService(ExternalContext externalContext) throws ClassNotFoundException, NoClassDefFoundError, InstantiationException, IllegalAccessException, InvocationTargetException, PrivilegedActionException {
        List<String> classList = (List<String>)externalContext.getApplicationMap().get(FACES_CONFIG_PROVIDER_LIST);
        if (classList == null) {
            classList = ServiceProviderFinderFactory.getServiceProviderFinder(externalContext).getServiceProviderList(FACES_CONFIG_PROVIDER);
            externalContext.getApplicationMap().put(FACES_CONFIG_PROVIDER_LIST, classList);
        }
        return ClassUtils.buildApplicationObject(FacesConfigResourceProvider.class, classList, new DefaultFacesConfigResourceProvider());
    }
}

