/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.push;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.util.AnnotationLiteral;
import javax.faces.event.WebsocketEvent;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.push.WebsocketSessionClusterSerializedRestore;
import org.apache.myfaces.push.cdi.WebsocketSessionManager;
import org.apache.myfaces.util.lang.Lazy;

public class EndpointImpl
extends Endpoint {
    public static final String JAVAX_FACES_PUSH_PATH = "/javax.faces.push/{channel}";
    public static final String PUSH_CHANNEL_PARAMETER = "channel";
    private static final Logger LOG = Logger.getLogger(EndpointImpl.class.getName());
    private static final AnnotationLiteral<WebsocketEvent.Opened> OPENED = new AnnotationLiteral<WebsocketEvent.Opened>(){
        private static final long serialVersionUID = 2789324L;
    };
    private static final AnnotationLiteral<WebsocketEvent.Closed> CLOSED = new AnnotationLiteral<WebsocketEvent.Closed>(){
        private static final long serialVersionUID = 38450203L;
    };
    private Lazy<BeanManager> beanManager = new Lazy<BeanManager>(() -> CDI.current().getBeanManager());

    public void onOpen(Session session, EndpointConfig config) {
        String channel = (String)session.getPathParameters().get(PUSH_CHANNEL_PARAMETER);
        String channelToken = session.getQueryString();
        WebsocketSessionManager sessionManager = CDIUtils.get(this.beanManager.get(), WebsocketSessionManager.class);
        if (Boolean.TRUE.equals(config.getUserProperties().get("oam.websocket.valid")) && sessionManager.addOrUpdateSession(channelToken, session)) {
            session.setMaxIdleTimeout(((Long)((Object)config.getUserProperties().getOrDefault("oam.websocket.maxIdleTimeout", 0))).longValue());
            Serializable user = (Serializable)session.getUserProperties().get("oam.websocket.user");
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "EndPointImpl.onOpen (channel = {0}, token = {1}, user = {2})", new Object[]{channel, channelToken, user});
            }
            if (user != null) {
                sessionManager.registerUser(user, channel, channelToken);
            }
            this.beanManager.get().fireEvent((Object)new WebsocketEvent(channel, user, null), new Annotation[]{OPENED});
            session.getUserProperties().put("oam.websocket.SR", new WebsocketSessionClusterSerializedRestore(channelToken));
        } else {
            try {
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, "Websocket connection not registered in current session"));
            }
            catch (IOException ex) {
                this.onError(session, ex);
            }
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        String channel = (String)session.getPathParameters().get(PUSH_CHANNEL_PARAMETER);
        String channelToken = session.getQueryString();
        Serializable user = (Serializable)session.getUserProperties().get("oam.websocket.user");
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "EndPointImpl.onClose (channel = {0}, token = {1}, user = {2})", new Object[]{channel, channelToken, user});
        }
        if (!this.beanManager.isInitialized()) {
            try {
                this.beanManager.get();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Could not lazy initialize BeanManager on Endpoint#close, skip deregister session...", e);
                return;
            }
        }
        WebsocketSessionManager sessionManager = CDIUtils.get(this.beanManager.get(), WebsocketSessionManager.class);
        sessionManager.removeSession(channelToken, session);
        if (user != null) {
            sessionManager.deregisterUser(user, channel, channelToken);
        }
        this.beanManager.get().fireEvent((Object)new WebsocketEvent(channel, user, closeReason.getCloseCode()), new Annotation[]{CLOSED});
    }

    public void onError(Session session, Throwable ex) {
        if (session.isOpen()) {
            session.getUserProperties().put(Throwable.class.getName(), ex);
        }
    }
}

