/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.resource;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.spi.ResourceLibraryContractsProvider;
import org.apache.myfaces.util.WebConfigParamUtils;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.view.facelets.util.Classpath;

public class DefaultResourceLibraryContractsProvider
extends ResourceLibraryContractsProvider {
    private static final String META_INF_CONTRACTS_PREFIX = "META-INF/contracts/";
    private static final String META_INF_CONTRACTS_SUFFIX = "javax.faces.contract.xml";
    private static final String META_INF_CONTRACTS_FILE = "/javax.faces.contract.xml";
    private static final String CONTRACTS = "contracts";

    @Override
    public Set<String> getExternalContextResourceLibraryContracts(ExternalContext context) throws IOException {
        String directory = WebConfigParamUtils.getStringInitParameter(context, "javax.faces.WEBAPP_CONTRACTS_DIRECTORY", CONTRACTS);
        if (directory.startsWith("/")) {
            throw new IllegalStateException("javax.faces.WEBAPP_CONTRACTS_DIRECTORY cannot start with '/");
        }
        if (directory.endsWith("/")) {
            directory = directory.substring(0, directory.length() - 1);
        }
        directory = '/' + directory + '/';
        HashSet<String> contracts = new HashSet<String>();
        Set<String> paths = context.getResourcePaths(directory);
        if (paths != null) {
            for (String path : paths) {
                if (!path.endsWith("/")) continue;
                contracts.add(path.substring(directory.length(), path.length() - 1));
            }
        }
        return contracts;
    }

    @Override
    public Set<String> getClassloaderResourceLibraryContracts(ExternalContext context) throws IOException {
        HashSet<String> contracts = new HashSet<String>();
        URL[] urls = Classpath.search(ClassUtils.getCurrentLoader(this), META_INF_CONTRACTS_PREFIX, META_INF_CONTRACTS_SUFFIX);
        for (int i = 0; i < urls.length; ++i) {
            String urlString = urls[i].toExternalForm();
            int suffixPos = urlString.lastIndexOf(META_INF_CONTRACTS_FILE);
            int slashPos = urlString.lastIndexOf(47, suffixPos - 1);
            if (suffixPos <= 0 || slashPos <= 0) continue;
            contracts.add(urlString.substring(slashPos + 1, suffixPos));
        }
        return contracts;
    }
}

