/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.validate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.el.ValueReference;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.validator.BeanValidator;
import javax.faces.validator.ValidatorException;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import org.apache.myfaces.component.validate.CopyBeanInterceptorELResolver;
import org.apache.myfaces.component.validate.ValidateWholeBeanComponent;
import org.apache.myfaces.component.validate._ELContextDecorator;
import org.apache.myfaces.component.validate._ValueReferenceResolver;
import org.apache.myfaces.shared.util.MessageUtils;
import org.apache.myfaces.shared.util.MyFacesObjectInputStream;
import org.apache.myfaces.util.ExternalSpecifications;

public class WholeBeanValidator
implements javax.faces.validator.Validator {
    private static final Logger log = Logger.getLogger(WholeBeanValidator.class.getName());
    private static final Class<?>[] DEFAULT_VALIDATION_GROUPS_ARRAY = new Class[]{Default.class};
    private static final String DEFAULT_VALIDATION_GROUP_NAME = "javax.validation.groups.Default";
    private static final String CANDIDATE_COMPONENT_VALUES_MAP = "oam.WBV.candidatesMap";
    private static final String BEAN_VALIDATION_FAILED = "oam.WBV.validationFailed";
    private Class<?>[] validationGroupsArray;

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        ValueExpression valueExpression = component.getValueExpression("value");
        if (valueExpression == null) {
            log.warning("cannot validate component with empty value: " + component.getClientId(context));
            return;
        }
        Object base = valueExpression.getValue(context.getELContext());
        Class<?> valueBaseClass = base.getClass();
        if (valueBaseClass == null) {
            return;
        }
        ValidatorFactory validatorFactory = this.createValidatorFactory(context);
        Validator validator = this.createValidator(validatorFactory, context, (ValidateWholeBeanComponent)component);
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(valueBaseClass);
        if (!beanDescriptor.isBeanConstrained()) {
            return;
        }
        Class[] validationGroupsArray = this.validationGroupsArray;
        Boolean beanValidationFailed = (Boolean)context.getViewRoot().getTransientStateHelper().getTransient(BEAN_VALIDATION_FAILED);
        if (Boolean.TRUE.equals(beanValidationFailed)) {
            return;
        }
        Map candidatesMap = (Map)context.getViewRoot().getTransientStateHelper().getTransient(CANDIDATE_COMPONENT_VALUES_MAP);
        if (candidatesMap != null) {
            Object copy = this.createBeanCopy(base);
            UpdateBeanCopyCallback callback = new UpdateBeanCopyCallback(this, base, copy, candidatesMap);
            context.getViewRoot().visitTree(VisitContext.createVisitContext(context, candidatesMap.keySet(), null), callback);
            Set constraintViolations = validator.validate(copy, validationGroupsArray);
            if (!constraintViolations.isEmpty()) {
                LinkedHashSet<FacesMessage> messages = new LinkedHashSet<FacesMessage>(constraintViolations.size());
                for (Object violation : constraintViolations) {
                    ConstraintViolation constraintViolation = (ConstraintViolation)violation;
                    String message = constraintViolation.getMessage();
                    Object[] args = new Object[]{message, MessageUtils.getLabel(context, component)};
                    FacesMessage msg = MessageUtils.getMessage(FacesMessage.SEVERITY_ERROR, "javax.faces.validator.BeanValidator.MESSAGE", args, context);
                    messages.add(msg);
                }
                throw new ValidatorException(messages);
            }
        }
    }

    private Object createBeanCopy(Object base) {
        Object copy = null;
        try {
            copy = base.getClass().newInstance();
        }
        catch (Exception ex) {
            Logger.getLogger(WholeBeanValidator.class.getName()).log(Level.FINEST, null, ex);
        }
        if (base instanceof Serializable) {
            copy = this.copySerializableObject(base);
        } else if (base instanceof Cloneable) {
            try {
                Method cloneMethod = base.getClass().getMethod("clone", new Class[0]);
                copy = cloneMethod.invoke(base, new Object[0]);
            }
            catch (Exception ex) {
                Logger.getLogger(WholeBeanValidator.class.getName()).log(Level.FINEST, null, ex);
            }
        } else {
            Class<?> clazz = base.getClass();
            try {
                Constructor<?> copyConstructor = clazz.getConstructor(clazz);
                if (copyConstructor != null) {
                    copy = copyConstructor.newInstance(base);
                }
            }
            catch (Exception ex) {
                Logger.getLogger(WholeBeanValidator.class.getName()).log(Level.FINEST, null, ex);
            }
        }
        if (copy == null) {
            throw new FacesException("Cannot create copy for wholeBeanValidator: " + base.getClass().getName());
        }
        return copy;
    }

    private Object copySerializableObject(Object base) {
        Object copy = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(base);
            oos.flush();
            oos.close();
            baos.close();
            byte[] byteData = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(byteData);
            try {
                copy = new MyFacesObjectInputStream(bais).readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return copy;
    }

    private Validator createValidator(ValidatorFactory validatorFactory, FacesContext context, ValidateWholeBeanComponent component) {
        if (this.validationGroupsArray == null) {
            this.postSetValidationGroups(component);
        }
        return validatorFactory.usingContext().messageInterpolator((MessageInterpolator)new FacesMessageInterpolator(validatorFactory.getMessageInterpolator(), context)).getValidator();
    }

    private ValueReference getValueReference(ValueExpression valueExpression, FacesContext context) {
        ELContext elCtx = context.getELContext();
        return _ValueReferenceResolver.resolve(valueExpression, elCtx);
    }

    private ValidatorFactory createValidatorFactory(FacesContext context) {
        Map<String, Object> applicationMap = context.getExternalContext().getApplicationMap();
        Object attr = applicationMap.get("javax.faces.validator.beanValidator.ValidatorFactory");
        if (attr instanceof ValidatorFactory) {
            return (ValidatorFactory)attr;
        }
        WholeBeanValidator wholeBeanValidator = this;
        synchronized (wholeBeanValidator) {
            if (ExternalSpecifications.isBeanValidationAvailable()) {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                applicationMap.put("javax.faces.validator.beanValidator.ValidatorFactory", factory);
                return factory;
            }
            throw new FacesException("Bean Validation is not present");
        }
    }

    private void postSetValidationGroups(ValidateWholeBeanComponent component) {
        String validationGroups = this.getValidationGroups(component);
        if (validationGroups == null || validationGroups.matches("^[\\W,]*$")) {
            this.validationGroupsArray = DEFAULT_VALIDATION_GROUPS_ARRAY;
        } else {
            String[] classes = validationGroups.split(",");
            ArrayList validationGroupsList = new ArrayList(classes.length);
            for (String clazz : classes) {
                if ((clazz = clazz.trim()).isEmpty()) continue;
                Class<?> theClass = null;
                ClassLoader cl = null;
                if (System.getSecurityManager() != null) {
                    try {
                        cl = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                            @Override
                            public ClassLoader run() throws PrivilegedActionException {
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        throw new FacesException(pae);
                    }
                } else {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                try {
                    theClass = Class.forName(clazz, false, cl);
                }
                catch (ClassNotFoundException ignore) {
                    try {
                        theClass = Class.forName(clazz, false, BeanValidator.class.getClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Could not load validation group", e);
                    }
                }
                validationGroupsList.add(theClass);
            }
            this.validationGroupsArray = validationGroupsList.toArray(new Class[validationGroupsList.size()]);
        }
    }

    public String getValidationGroups(ValidateWholeBeanComponent component) {
        return component.getValidationGroups();
    }

    public void setValidationGroups(ValidateWholeBeanComponent component, String validationGroups) {
        component.setValidationGroups(validationGroups);
    }

    private static class UpdateBeanCopyCallback
    implements VisitCallback {
        private WholeBeanValidator validator;
        private Object wholeBeanBase;
        private Object wholeBeanBaseCopy;
        private Map<String, Object> candidateValuesMap;

        public UpdateBeanCopyCallback(WholeBeanValidator validator, Object wholeBeanBase, Object wholeBeanBaseCopy, Map<String, Object> candidateValuesMap) {
            this.validator = validator;
            this.wholeBeanBase = wholeBeanBase;
            this.wholeBeanBaseCopy = wholeBeanBaseCopy;
            this.candidateValuesMap = candidateValuesMap;
        }

        @Override
        public VisitResult visit(VisitContext context, UIComponent target) {
            ValueExpression valueExpression = target.getValueExpression("value");
            if (valueExpression == null) {
                log.warning("cannot validate component with empty value: " + target.getClientId(context.getFacesContext()));
                return VisitResult.ACCEPT;
            }
            ValueReference reference = this.validator.getValueReference(valueExpression, context.getFacesContext());
            if (reference == null) {
                return VisitResult.ACCEPT;
            }
            Object base = reference.getBase();
            if (base == null) {
                return VisitResult.ACCEPT;
            }
            Object referenceProperty = reference.getProperty();
            if (!(referenceProperty instanceof String)) {
                return VisitResult.ACCEPT;
            }
            if (base == this.wholeBeanBase || base.equals(this.wholeBeanBase)) {
                _ELContextDecorator elCtxDecorator = new _ELContextDecorator(context.getFacesContext().getELContext(), new CopyBeanInterceptorELResolver(context.getFacesContext().getApplication().getELResolver(), this.wholeBeanBase, this.wholeBeanBaseCopy));
                valueExpression.setValue((ELContext)elCtxDecorator, this.candidateValuesMap.get(target.getClientId(context.getFacesContext())));
            }
            return VisitResult.ACCEPT;
        }
    }

    private static class FacesMessageInterpolator
    implements MessageInterpolator {
        private final FacesContext facesContext;
        private final MessageInterpolator interpolator;

        public FacesMessageInterpolator(MessageInterpolator interpolator, FacesContext facesContext) {
            this.interpolator = interpolator;
            this.facesContext = facesContext;
        }

        public String interpolate(String s, MessageInterpolator.Context context) {
            Locale locale = this.facesContext.getViewRoot().getLocale();
            return this.interpolator.interpolate(s, context, locale);
        }

        public String interpolate(String s, MessageInterpolator.Context context, Locale locale) {
            return this.interpolator.interpolate(s, context, locale);
        }
    }
}

