/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import jakarta.faces.context.ExternalContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.NavigationCase;
import org.apache.myfaces.config.element.NavigationRule;

public class FacesConfigValidator {
    private FacesConfigValidator() {
    }

    public static List<String> validate(ExternalContext ctx) {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(ctx);
        Collection<NavigationRule> navRules = runtimeConfig.getNavigationRules();
        return FacesConfigValidator.validate(navRules, ctx);
    }

    public static List<String> validate(Collection<? extends NavigationRule> navRules, ExternalContext ctx) {
        ArrayList<String> list = new ArrayList<String>();
        if (navRules != null) {
            FacesConfigValidator.validateNavRules(navRules, list, ctx);
        }
        return list;
    }

    private static void validateNavRules(Collection<? extends NavigationRule> navRules, List<String> list, ExternalContext ctx) {
        for (NavigationRule navigationRule : navRules) {
            FacesConfigValidator.validateNavRule(navigationRule, list, ctx);
        }
    }

    private static void validateNavRule(NavigationRule navRule, List<String> list, ExternalContext ctx) {
        String fromId = navRule.getFromViewId();
        try {
            URL filePath = ctx.getResource(fromId);
            if (fromId != null && !"*".equals(fromId) && filePath == null) {
                list.add("File for navigation 'from id' does not exist " + filePath);
            }
        }
        catch (MalformedURLException e) {
            list.add("File for navigation 'from id' does not exist " + fromId);
        }
        for (NavigationCase navigationCase : navRule.getNavigationCases()) {
            try {
                URL toViewPath = ctx.getResource(navigationCase.getToViewId());
                if (toViewPath != null) continue;
                list.add("File for navigation 'to id' does not exist " + toViewPath);
            }
            catch (MalformedURLException e) {
                list.add("File for navigation 'from id' does not exist " + navigationCase.getToViewId());
            }
        }
    }
}

